/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.io;

import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.lucene.io.IndexManager;
import de.cadenas.util.PLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IndexIDRangeProvider
implements IIndexManager.IIndexIDRangeProvider {
    private static PLogger logger = new PLogger(IndexManager.class.getSimpleName());
    private int docIdCounter = 0;
    private final List<Range> freeList = new ArrayList<Range>();
    private final RangeComparator comparator = new RangeComparator();

    @Override
    public synchronized IIndexManager.IIndexIDRangeProvider.IRange getRange(int size) {
        Range range = new Range(0, size);
        int pos = Collections.binarySearch(this.freeList, range, this.comparator);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        if (pos < this.freeList.size()) {
            return this.freeList.remove(pos);
        }
        int baseDocId = this.docIdCounter;
        this.docIdCounter += size;
        range.b = baseDocId;
        if (this.docIdCounter < 0) {
            logger.error("docId overflow");
        }
        return range;
    }

    @Override
    public synchronized void freeRange(int baseId, int size) {
        Range range = new Range(baseId, size);
        int pos = Collections.binarySearch(this.freeList, range, this.comparator);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        this.freeList.add(pos, range);
    }

    class RangeComparator
    implements Comparator<Range> {
        RangeComparator() {
        }

        @Override
        public int compare(Range o1, Range o2) {
            return o1.size() - o2.size();
        }
    }

    class Range
    implements IIndexManager.IIndexIDRangeProvider.IRange {
        private int b;
        private int s;

        Range(int base, int size) {
            this.b = base;
            this.s = size;
        }

        @Override
        public int base() {
            return this.b;
        }

        @Override
        public int size() {
            return this.s;
        }
    }
}

