/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.index;

import de.cadenas.util.PFile;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class VirtualFacetMapper {
    private final Map<String, MappingItem> values = new HashMap<String, MappingItem>();
    private final Object2IntMap<String> names = new Object2IntOpenHashMap<String>();
    private final Int2ObjectMap<String> reverseLookup = new Int2ObjectOpenHashMap<String>();
    private final Map<String, List<String>> virtualToClassIds = new HashMap<String, List<String>>();
    private static VirtualFacetMapper instance = null;

    public static synchronized VirtualFacetMapper getInstance() {
        if (instance == null) {
            instance = new VirtualFacetMapper();
        }
        return instance;
    }

    private VirtualFacetMapper() {
        String path = "$CADENAS_DATA/datasetup/classsystem/by_categories_20/maptoeclass.csv";
        byte[] fileData = PFile.readFileContents(path);
        if (fileData != null && fileData.length > 0) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileData);){
                String line;
                HashSet<MappingItem> uniqueItems = new HashSet<MappingItem>();
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    int facetId;
                    MappingItem item;
                    String[] lineParts = line.split(";");
                    if (lineParts.length < 3 || !uniqueItems.add(item = new MappingItem(lineParts[2], facetId = this.names.computeIntIfAbsent(lineParts[0], k -> {
                        int id = this.names.size();
                        this.reverseLookup.put(id, lineParts[0]);
                        return id;
                    })))) continue;
                    this.values.put(item.prefix, item);
                    List classIdList = this.virtualToClassIds.computeIfAbsent(lineParts[0], k -> new ArrayList());
                    classIdList.add(lineParts[2]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public IntArrayList getVirtualFacet(String value) {
        IntArrayList resultList = null;
        while (true) {
            int idx;
            MappingItem item;
            if ((item = this.values.get(value)) != null) {
                if (resultList == null) {
                    resultList = new IntArrayList();
                }
                resultList.add(item.index);
            }
            if ((idx = value.lastIndexOf(45)) == -1) break;
            value = value.substring(0, idx);
        }
        return resultList;
    }

    public String getFacetName(int id) {
        return (String)this.reverseLookup.get(id);
    }

    public String getCategoryPrefix() {
        if (!this.values.isEmpty()) {
            return "facet_cls_eclass";
        }
        return "";
    }

    public List<String> getClassIdsByVirtualId(String id) {
        return this.virtualToClassIds.get(id);
    }

    private record MappingItem(String prefix, int index) {
    }
}

