/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;

public class PSolMergePolicy
extends LogDocMergePolicy {
    private int maxNumDeletedDocuments = 100;

    void setMaxNumDeleteDocuments(int max) {
        this.maxNumDeletedDocuments = max;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        int delCount = 0;
        List<SegmentCommitInfo> segments = segmentInfos.asList();
        for (SegmentCommitInfo info : segments) {
            delCount += mergeContext.numDeletesToMerge(info);
        }
        if (delCount > this.maxNumDeletedDocuments) {
            return super.findForcedDeletesMerges(segmentInfos, mergeContext);
        }
        return null;
    }
}

