/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.index;

import de.cadenas.util.PConfig;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.pdf.PDFParserConfig;

class OcrConfig {
    private static OcrConfig instance;
    private String _tesseractPath;
    private String _tesseractData;
    private int _dpi = 600;
    private String _formatName;

    private OcrConfig() {
    }

    public static synchronized OcrConfig getInstance() {
        if (instance == null) {
            instance = new OcrConfig();
            try (PConfig config = new PConfig("$CADENAS_SETUP/partsol.cfg");){
                String blockName = "INDEX:OCR";
                OcrConfig.instance._tesseractPath = config.getValue("TesseractPath", "INDEX:OCR");
                OcrConfig.instance._tesseractData = config.getValue("TesseractDataPath", "INDEX:OCR");
                OcrConfig.instance._dpi = config.getInt("Dpi", "INDEX:OCR");
                if (OcrConfig.instance._dpi == 0) {
                    OcrConfig.instance._dpi = 600;
                }
                OcrConfig.instance._formatName = config.getValue("ImageFormat", "INDEX:OCR");
            }
        }
        return instance;
    }

    public void configureContext(ParseContext context) {
        if (this._tesseractPath != null && !this._tesseractPath.isEmpty()) {
            TesseractOCRConfig ocrConfig = new TesseractOCRConfig();
            PDFParserConfig pdfParserConfig = new PDFParserConfig();
            pdfParserConfig.setOcrStrategy(PDFParserConfig.OCR_STRATEGY.AUTO);
            if (this._dpi != 0) {
                pdfParserConfig.setOcrDPI(this._dpi);
            }
            if (this._formatName != null && !this._formatName.isEmpty()) {
                pdfParserConfig.setOcrImageFormatName(this._formatName);
            }
            pdfParserConfig.setExtractInlineImages(true);
            context.set(PDFParserConfig.class, (Object)pdfParserConfig);
            context.set(TesseractOCRConfig.class, (Object)ocrConfig);
        }
    }
}

