/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.index;

import de.cadenas.util.Containers;
import de.cadenas.util.PDataStream;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

public class FieldInfoData {
    public int numDocs = 0;
    public int numDeletedDocs = 0;
    public List<Item> fields = null;

    public byte[] toBinary() throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PDataStream stream = new PDataStream(outStream);
        stream.write(this.numDocs);
        stream.write(this.numDeletedDocs);
        if (this.fields != null) {
            stream.write(this.fields.size());
            for (Item field : this.fields) {
                stream.write(field.fieldName);
                if (field.terms != null) {
                    stream.write(field.terms.size());
                    for (Term term : field.terms) {
                        stream.write(term.term);
                        if (term.documents != null) {
                            stream.write(term.documents.size());
                            for (Doc doc : term.documents) {
                                stream.write(doc.id);
                                stream.write(doc.freq);
                                if (doc.positions != null) {
                                    stream.write(doc.positions.size());
                                    IntListIterator intListIterator = doc.positions.iterator();
                                    while (intListIterator.hasNext()) {
                                        int pos = (Integer)intListIterator.next();
                                        stream.write(pos);
                                    }
                                    intListIterator = doc.payloads.iterator();
                                    while (intListIterator.hasNext()) {
                                        int payload = (Integer)intListIterator.next();
                                        stream.write(payload);
                                    }
                                    continue;
                                }
                                stream.write(0);
                            }
                            continue;
                        }
                        stream.write(0);
                    }
                    continue;
                }
                stream.write(0);
            }
        } else {
            stream.write(0);
        }
        return outStream.toByteArray();
    }

    public static class Item {
        public String fieldName = "";
        public List<Term> terms = null;

        public String toString() {
            return this.fieldName;
        }
    }

    public static class Term {
        public String term;
        public List<Doc> documents = null;
    }

    public static class Doc {
        public int id = -1;
        public int freq = 0;
        public Containers.IntList positions = null;
        public Containers.IntList payloads = null;
    }
}

