/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class CatalogMappingIndexReader
extends MultiReader {
    private final List<String> catalogMappings;
    private final CacheHelperImpl cacheHelper;

    public CatalogMappingIndexReader(IndexReader[] subReaders, List<String> catalogs, boolean closeSubReaders) throws IOException {
        super(subReaders, closeSubReaders);
        this.catalogMappings = catalogs;
        this.cacheHelper = new CacheHelperImpl();
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.cacheHelper;
    }

    public List<String> getCatalogList() {
        return this.catalogMappings;
    }

    public String getCatalogForDocId(int docId) {
        int index = this.readerIndex(docId);
        if (index >= 0 && index < this.catalogMappings.size()) {
            return this.catalogMappings.get(index);
        }
        return "";
    }

    public IndexReader readerByDocId(int docId) {
        int index = this.readerIndex(docId);
        return (IndexReader)this.getSequentialSubReaders().get(index);
    }

    public int docIdBase(int docId) {
        int ri = this.readerIndex(docId);
        return this.readerBase(ri);
    }

    public List<Range> getDocIdRange(String catalog, boolean byPrefix) {
        ArrayList<Range> rangeList = new ArrayList<Range>();
        for (int i = 0; i < this.catalogMappings.size(); ++i) {
            String catalogName = this.catalogMappings.get(i);
            boolean found = false;
            found = byPrefix ? catalogName.startsWith(catalog) : catalogName.equals(catalog);
            if (!found) continue;
            Range range = new Range();
            range.lowBorder = this.readerBase(i);
            range.upperBorder = i + 1 < this.catalogMappings.size() ? this.readerBase(i + 1) : this.maxDoc();
            rangeList.add(range);
            if (!byPrefix) break;
        }
        return rangeList;
    }

    public List<Range> getDocIdRange(int readerIndex, String field, String value, boolean byPrefix) throws IOException {
        ArrayList<Range> rangeList = new ArrayList<Range>();
        BytesRef keyToFind = new BytesRef(value);
        CompiledAutomaton compiled = null;
        if (byPrefix) {
            compiled = new CompiledAutomaton(PrefixQuery.toAutomaton(keyToFind), null, true, Integer.MAX_VALUE, true);
        }
        IndexReader reader = (IndexReader)this.getSequentialSubReaders().get(readerIndex);
        List<LeafReaderContext> leafContexts = reader.getContext().leaves();
        for (LeafReaderContext ctx : leafContexts) {
            TermsEnum te;
            LeafReader leafReader = ctx.reader();
            Terms fieldTerms = leafReader.terms(field);
            if (fieldTerms == null) continue;
            if (byPrefix) {
                te = compiled.getTermsEnum(fieldTerms);
                BytesRef bytes = te.next();
                while (bytes != null) {
                    this.collectDocIdRange(te, ctx.docBase, rangeList);
                    bytes = te.next();
                }
                continue;
            }
            te = fieldTerms.iterator();
            if (te == null || !te.seekExact(keyToFind)) continue;
            this.collectDocIdRange(te, ctx.docBase, rangeList);
        }
        return rangeList;
    }

    private void collectDocIdRange(TermsEnum te, int docBase, List<Range> rangeList) throws IOException {
        int rangeBegin = Integer.MIN_VALUE;
        int rangeEnd = Integer.MIN_VALUE;
        PostingsEnum docIterator = te.postings(null, 0);
        int docID = docIterator.nextDoc();
        while (docID != Integer.MAX_VALUE) {
            if (rangeBegin == Integer.MIN_VALUE) {
                rangeBegin = docID;
                rangeEnd = docID + 1;
            } else if (rangeEnd != docID) {
                rangeList.add(new Range(rangeBegin + docBase, rangeEnd + docBase));
                rangeBegin = docID;
                rangeEnd = docID + 1;
            } else {
                rangeEnd = docID + 1;
            }
            docID = docIterator.nextDoc();
        }
        if (rangeBegin != Integer.MIN_VALUE) {
            rangeList.add(new Range(rangeBegin + docBase, rangeEnd + docBase));
        }
    }

    public int findCatalog(String catalog) {
        for (int i = 0; i < this.catalogMappings.size(); ++i) {
            if (!this.catalogMappings.get(i).equals(catalog)) continue;
            return i;
        }
        return -1;
    }

    private static class CacheHelperImpl
    implements IndexReader.CacheHelper {
        private CacheHelperImpl() {
        }

        @Override
        public IndexReader.CacheKey getKey() {
            return null;
        }

        @Override
        public void addClosedListener(IndexReader.ClosedListener listener) {
        }
    }

    public static class Range {
        public int lowBorder;
        public int upperBorder;

        public Range() {
            this.lowBorder = 0;
            this.upperBorder = 0;
        }

        public Range(int lowBorder, int upperBorder) {
            this.lowBorder = lowBorder;
            this.upperBorder = upperBorder;
        }
    }
}

