/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.HighlightingRequest;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightUtils;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNode;
import de.cadenas.catalogsearch.lucene.search.ValueRangeQuery;
import de.cadenas.util.NumUtils;
import de.cadenas.util.PGenericPair;
import it.unimi.dsi.fastutil.ints.IntList;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ValueRangeHighlightingNode
extends HighlightingNode {
    protected double numericalValue = Double.NaN;
    private static final double EPSILON = 1.0E-5;
    private final int physicalQuantity;
    private final boolean searchOriginalValue;
    private final PGenericPair<Double, Double> valueRange = new PGenericPair<Double, Double>(Double.NaN, Double.NaN);
    private final NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
    private static final Pattern numberPattern = Pattern.compile("\\d+(\\.\\d+)?");

    public ValueRangeHighlightingNode(ValueRangeQuery valueRangeQuery, HighlightingNode parent) {
        this.format.setMaximumFractionDigits(8);
        this.format.setGroupingUsed(false);
        String fieldToAdd = valueRangeQuery.field;
        int atIndex = fieldToAdd.indexOf(64);
        if (atIndex != -1) {
            fieldToAdd = fieldToAdd.substring(0, atIndex);
        }
        this.field = fieldToAdd;
        this.value = this.format.format(valueRangeQuery.originalValue);
        this.setParent(parent);
        if (valueRangeQuery.physicalQuantity != 0 || Double.compare(Double.NaN, valueRangeQuery.originalValue) == 0) {
            this.setValueRange(valueRangeQuery.minValue, valueRangeQuery.maxValue);
        } else {
            this.numericalValue = valueRangeQuery.originalValue;
        }
        this.physicalQuantity = valueRangeQuery.physicalQuantity;
        this.searchOriginalValue = valueRangeQuery.searchOriginalValue;
        HighlightUtils.putIntoListMap(this.unStemmedNonLanguageValues, fieldToAdd, Long.toString(Math.round(valueRangeQuery.originalValue)));
    }

    public void setValueRange(double min, double max) {
        this.valueRange.first = min;
        this.valueRange.second = max;
    }

    public Double getMin() {
        return (Double)this.valueRange.first;
    }

    public Double getMax() {
        return (Double)this.valueRange.second;
    }

    public boolean rangeValid() {
        return !Double.isNaN((Double)this.valueRange.first);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("value", (Object)this.value).append("field", (Object)this.field).append("highlighted", this.highlighted).append("occur", (Object)this.occur).append("queryLength", this.queryLength).append("numericalValue", this.numericalValue).append("valueRange", this.valueRange).toString();
    }

    @Override
    public void onChildDetached(HighlightingNode child) {
        this.children.remove(child);
        this.detachFromParent();
    }

    private boolean valueIsValid(double value) {
        return this.numericalValue == value || this.rangeValid() && this.inBetween(value, this.getMin(), this.getMax());
    }

    private double parseValueNumber(String value) {
        double numValue = NumUtils.getNumeric(value);
        if (Double.isNaN(numValue)) {
            numValue = NumUtils.parseInch(value);
        }
        return numValue;
    }

    private int highlightNumber(double numValue, NumericalHighlightingParams highlightValues) {
        if (this.valueIsValid(numValue)) {
            if (numValue == this.numericalValue || this.inBetween(numValue, this.getMin(), this.getMax())) {
                highlightValues.highlightingPositions[0] = highlightValues.strValue.length();
                return 0;
            }
            String valueString = (double)((int)numValue) == numValue ? Integer.toString((int)numValue) : this.format.format(numValue);
            int index = highlightValues.strValue.indexOf(valueString);
            if (index != -1) {
                highlightValues.highlightingPositions[index] = valueString.length();
                return index;
            }
        }
        return -1;
    }

    private boolean processAsNumber(HighlightingRequest.Fragment frag) {
        if (this.physicalQuantity != 0 && frag.physicalQuantity != this.physicalQuantity) {
            return false;
        }
        NumericalHighlightingParams highlightValues = new NumericalHighlightingParams(this.getMin(), this.getMax(), new int[frag.value.length()], frag.value);
        int numberIndex = this.highlightNumber(frag.convertedValue, highlightValues);
        int fragIndex = this.fragmentInventory.request.fragments.indexOf(frag);
        if (numberIndex == -1) {
            double numValue = frag.convertedValue;
            if (this.physicalQuantity == 0 && !this.format.format(numValue).equals(frag.value)) {
                numValue = this.parseValueNumber(frag.value);
            }
            numberIndex = this.highlightNumber(numValue, highlightValues);
        }
        if (numberIndex != -1) {
            HighlightUtils.updateHighlightMap(this.highlightPositions, fragIndex, highlightValues.highlightingPositions, numberIndex);
            return true;
        }
        return false;
    }

    private void processAsText(HighlightingRequest.Fragment frag, int fragmentIndex) {
        int[] highlightBuffer = new int[frag.value.length()];
        Matcher matcher = numberPattern.matcher(frag.value);
        while (matcher.find()) {
            double number = Double.parseDouble(matcher.group());
            if (Double.isNaN(number) || number != this.numericalValue && !this.inBetween(number, this.getMin(), this.getMax())) continue;
            highlightBuffer[matcher.start()] = matcher.end();
            HighlightUtils.updateHighlightMap(this.highlightPositions, fragmentIndex, highlightBuffer, matcher.start());
        }
    }

    @Override
    public void resolveHighlightPositions() {
        IntList fragmentIndices = this.fragmentInventory.getFragmentIndicesForNonLangField(this.field);
        if (fragmentIndices == null) {
            return;
        }
        for (Integer index : fragmentIndices) {
            HighlightingRequest.Fragment frag = this.fragmentInventory.request.fragments.get(index);
            if (!this.searchOriginalValue && frag.physicalQuantity != this.physicalQuantity || this.processAsNumber(frag)) continue;
            this.processAsText(frag, index);
        }
        this.highlighted = !this.highlightPositions.isEmpty();
    }

    private boolean inBetween(double value, double min, double max) {
        return value >= min - 1.0E-5 && value <= max + 1.0E-5;
    }

    public record NumericalHighlightingParams(double min, double max, int[] highlightingPositions, String strValue) {
        public NumericalHighlightingParams {
            Arrays.fill(highlightingPositions, -1);
        }
    }
}

