/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.lucene.highlighting.HighlightTokenContainer;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightUtils;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNode;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemExact;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemPhrase;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemTerm;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemTermList;
import de.cadenas.util.PGenericPair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;

public class StrictHighlightingNode
extends HighlightingNode {
    boolean isExactStrict = false;
    PSolQueryItemPhrase localPhItem;
    private final Int2ObjectOpenHashMap<HighlightTokenContainer.HighlightToken> foundFragments = new Int2ObjectOpenHashMap();
    private final List<PGenericPair<List<String>, Boolean>> validSearchTerms = new ArrayList<PGenericPair<List<String>, Boolean>>();

    public StrictHighlightingNode(PSolQueryItemPhrase phraseItem, HighlightingNode parent) {
        super(phraseItem.getSearchField(), "", parent);
        for (PSolQueryItem item : phraseItem.getItemList()) {
            this.createItems(item);
        }
        this.localPhItem = phraseItem;
    }

    private void createItems(PSolQueryItem item) {
        if (item instanceof PSolQueryItemTerm) {
            PSolQueryItemTerm termItem = (PSolQueryItemTerm)item;
            this.validSearchTerms.add(new PGenericPair<ArrayList<String>, Boolean>(new ArrayList<String>(Collections.singleton(termItem.getTerm().text())), false));
        } else if (item instanceof PSolQueryItemExact) {
            PSolQueryItemExact exactItem = (PSolQueryItemExact)item;
            this.validSearchTerms.add(new PGenericPair<ArrayList<String>, Boolean>(new ArrayList<String>(Collections.singleton(exactItem.toString().split(":")[1])), false));
            this.isExactStrict = true;
        } else if (item instanceof PSolQueryItemTermList) {
            PSolQueryItemTermList termListNode = (PSolQueryItemTermList)item;
            ArrayList<String> terms = new ArrayList<String>();
            for (PSolQueryItemTermList.TermItem termItem : termListNode.getTermList()) {
                terms.add(termItem.getTerm().text());
            }
            this.validSearchTerms.add(new PGenericPair(terms, false));
        } else if (item instanceof PSolQueryItemBoost) {
            PSolQueryItemBoost bItem = (PSolQueryItemBoost)item;
            this.createItems(bItem.getChildItem());
        } else {
            throw new NotImplementedException();
        }
    }

    private void highlightExactStrict(String termWord, int[] previousIndexBuffer, HighlightTokenContainer.HighlightToken fragmentToken) {
        for (int i = this.validSearchTerms.size() - 1; i >= 0; --i) {
            String word = (String)((List)this.validSearchTerms.get((int)i).first).get(0);
            if (this.validSearchTerms.stream().noneMatch(entry -> ((String)((List)entry.first).get(0)).equals(termWord))) {
                this.resetHighlighting(previousIndexBuffer);
                return;
            }
            if (!word.equals(termWord) || previousIndexBuffer[fragmentToken.startOffset()] >= fragmentToken.endOffset()) continue;
            if (((Boolean)this.validSearchTerms.get((int)i).second).booleanValue()) {
                this.resetHighlighting(previousIndexBuffer);
                return;
            }
            previousIndexBuffer[fragmentToken.startOffset()] = fragmentToken.endOffset();
            this.foundFragments.put(fragmentToken.startOffset(), fragmentToken);
            this.validSearchTerms.get((int)i).second = true;
        }
    }

    private void highlightStandardStrict(String termWord, int[] previousIndexBuffer, HighlightTokenContainer.HighlightToken fragmentToken) {
        for (PGenericPair<List<String>, Boolean> validSearchTerm : this.validSearchTerms) {
            if (!((List)validSearchTerm.first).stream().anyMatch(searchTerm -> HighlightUtils.replaceUmlaut(searchTerm).equals(HighlightUtils.replaceUmlaut(termWord)))) continue;
            if (previousIndexBuffer[fragmentToken.startOffset()] < fragmentToken.endOffset()) {
                previousIndexBuffer[fragmentToken.startOffset()] = fragmentToken.endOffset();
                this.foundFragments.put(fragmentToken.startOffset(), fragmentToken);
            }
            validSearchTerm.second = true;
        }
    }

    private void resetMarkers() {
        for (PGenericPair<List<String>, Boolean> entry : this.validSearchTerms) {
            entry.second = false;
        }
        this.foundFragments.clear();
    }

    private void resetHighlighting(int[] previousIndexBuffer) {
        Arrays.fill(previousIndexBuffer, -1);
        this.resetMarkers();
    }

    private boolean allTermsFound() {
        return this.validSearchTerms.stream().allMatch(entry -> (Boolean)entry.second);
    }

    private boolean termsMissing() {
        return this.validSearchTerms.stream().anyMatch(pair -> (Boolean)pair.second == false);
    }

    @Override
    public void analyseFragmentStream(HighlightTokenContainer fragmentTokenContainer, HighlightTokenContainer stemmedSearchTerms, int[] previousIndexBuffer) {
        List<HighlightTokenContainer.HighlightToken> fragmentTokens = fragmentTokenContainer.tokens;
        for (int i = 0; i < fragmentTokens.size(); ++i) {
            HighlightTokenContainer.HighlightToken fragmentToken = fragmentTokens.get(i);
            String termWord = fragmentToken.term();
            if (i != 0 && this.allTermsFound() && fragmentToken.startOffset() != fragmentTokens.get(i - 1).startOffset()) {
                this.resetHighlighting(previousIndexBuffer);
                return;
            }
            if (this.isExactStrict) {
                this.highlightExactStrict(termWord, previousIndexBuffer, fragmentToken);
            } else {
                this.highlightStandardStrict(termWord, previousIndexBuffer, fragmentToken);
            }
            if (this.validSearchTerms.size() != 1 || !this.termsMissing()) continue;
            this.resetHighlighting(previousIndexBuffer);
            return;
        }
        if (this.termsMissing()) {
            this.resetHighlighting(previousIndexBuffer);
            return;
        }
        ArrayList<HighlightTokenContainer.HighlightToken> sortedFragments = new ArrayList<HighlightTokenContainer.HighlightToken>(this.foundFragments.values());
        sortedFragments.sort(Comparator.comparingInt(HighlightTokenContainer.HighlightToken::startOffset));
        HighlightUtils.mergeHighlightTokenPositions(previousIndexBuffer, sortedFragments);
        this.resetMarkers();
    }
}

