/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

public class PositionSpanSearcher {
    private int adjacentTerms = 0;
    private int lastWordEndIndex = -1;
    private int lastWordStartIndex = -1;

    private ProximityOperation isAtStartOrDefault(int startOffset) {
        return this.isAtStart(startOffset) ? ProximityOperation.AT_START : ProximityOperation.DEFAULT;
    }

    private boolean isAtStart(int startOffset) {
        return this.lastWordStartIndex == startOffset || this.lastWordStartIndex - 1 == startOffset || this.lastWordStartIndex - 2 == startOffset;
    }

    private boolean isAtEnd(int startOffset, int endOffset) {
        return this.lastWordEndIndex == endOffset || this.lastWordEndIndex == startOffset || this.lastWordEndIndex + 1 == startOffset || this.lastWordEndIndex + 2 == startOffset;
    }

    private ProximityOperation defineOperation(int startOffset, int endOffset) {
        return this.isAtEnd(startOffset, endOffset) ? ProximityOperation.AT_END : this.isAtStartOrDefault(startOffset);
    }

    public void doSpanSearch(int startOffset, int[] previousBuffer) {
        int endOffset = previousBuffer[startOffset];
        ProximityOperation op = this.adjacentTerms == 0 ? ProximityOperation.START : this.defineOperation(startOffset, endOffset);
        switch (op) {
            case START: {
                this.lastWordEndIndex = endOffset;
                this.lastWordStartIndex = startOffset;
                ++this.adjacentTerms;
                break;
            }
            case AT_START: {
                this.lastWordStartIndex = startOffset;
                ++this.adjacentTerms;
                break;
            }
            case AT_END: {
                this.lastWordEndIndex = endOffset;
                ++this.adjacentTerms;
                break;
            }
            case DEFAULT: {
                this.lastWordStartIndex = startOffset;
                this.lastWordEndIndex = endOffset;
                this.adjacentTerms = 1;
            }
        }
    }

    public void reset() {
        this.adjacentTerms = 0;
        this.lastWordEndIndex = -1;
        this.lastWordStartIndex = -1;
    }

    private boolean isBiggerSpan(int stemmedSearchTermsSize) {
        return (this.adjacentTerms >= 2 || stemmedSearchTermsSize == 1) && this.lastWordStartIndex != -1 && this.lastWordEndIndex != -1;
    }

    public boolean foundSpan(int searchLength, int stemmedSearchTermsSize) {
        return this.lastWordEndIndex - this.lastWordStartIndex >= searchLength && this.isBiggerSpan(stemmedSearchTermsSize);
    }

    public void addSpanToBuffer(int[] buffer) {
        buffer[this.lastWordStartIndex] = this.lastWordEndIndex;
        this.reset();
    }

    static enum ProximityOperation {
        START,
        AT_END,
        AT_START,
        DEFAULT;

    }
}

