/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.HighlightingRequest;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightTokenContainer;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightUtils;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.IHighlightingInfoReceiver;
import de.cadenas.catalogsearch.lucene.highlighting.OrHighlightingNode;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemAutomaton;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemExact;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemPhrase;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemTerm;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemTermList;
import de.cadenas.util.NumUtils;
import de.cadenas.util.PGenericPair;
import de.cadenas.util.PLogger;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class PhraseHighlightingNode
extends HighlightingNode {
    private final PSolQueryItemPhrase phraseItem;
    private final OrHighlightingNode parentRef;
    private static final PLogger logger = new PLogger(PhraseHighlightingNode.class.getSimpleName());
    private final List<PGenericPair<List<String>, Boolean>> queryItemList = new ArrayList<PGenericPair<List<String>, Boolean>>();

    public PhraseHighlightingNode(PSolQueryItemPhrase phraseItem, HighlightingNode parent) {
        super(phraseItem.getSearchField(), "", parent);
        OrHighlightingNode orParent;
        this.createItemList(phraseItem);
        this.phraseItem = phraseItem;
        this.parentRef = parent instanceof OrHighlightingNode ? (orParent = (OrHighlightingNode)parent) : null;
        this.processPhraseQueryElements();
    }

    private void createItemList(PSolQueryItemPhrase phraseItem) {
        for (PSolQueryItem item : phraseItem.getItemList()) {
            this.queryItemList.add(this.createSearchTermsItem(item));
        }
    }

    private PGenericPair<List<String>, Boolean> createSearchTermsItem(PSolQueryItem item) {
        ArrayList<String> searchTerms = new ArrayList<String>();
        if (item instanceof PSolQueryItemBoost) {
            PSolQueryItemBoost boostItem = (PSolQueryItemBoost)item;
            return this.createSearchTermsItem(boostItem.getChildItem());
        }
        if (item instanceof PSolQueryItemExact) {
            PSolQueryItemExact exactNode = (PSolQueryItemExact)item;
            searchTerms.add(exactNode.toString().split(":")[1]);
        } else if (item instanceof PSolQueryItemTerm) {
            PSolQueryItemTerm termNode = (PSolQueryItemTerm)item;
            searchTerms.add(termNode.getTerm().text());
        } else if (item instanceof PSolQueryItemTermList) {
            PSolQueryItemTermList termListNode = (PSolQueryItemTermList)item;
            for (PSolQueryItemTermList.TermItem termItem : termListNode.getTermList()) {
                searchTerms.add(termItem.getTerm().text());
            }
            searchTerms.sort(Comparator.comparingInt(String::length));
        } else if (item instanceof PSolQueryItemAutomaton) {
            PSolQueryItemAutomaton automatonItem = (PSolQueryItemAutomaton)item;
        } else if (item == null) {
            logger.error("PSolQueryItem was null, when creating search Terms for Node!");
        } else {
            logger.error(item.toString());
        }
        return new PGenericPair<List<String>, Boolean>(searchTerms, false);
    }

    @Override
    public void resolveHighlightPositions() {
        IntList fragmentIndices = this.fragmentInventory.getFragmentIndicesForLangField(this.field);
        if (fragmentIndices == null) {
            return;
        }
        for (Integer index : fragmentIndices) {
            HighlightingRequest.Fragment frag = this.fragmentInventory.request.fragments.get(index);
            int fragmentValueLength = frag.value.length();
            HashMap<String, List<String>> singleValueMap = new HashMap<String, List<String>>();
            singleValueMap.put(this.field, new ArrayList<String>(Collections.singleton(frag.value)));
            HighlightTokenContainer searchValues = this.stemmer.stemValues(singleValueMap, this.fragmentInventory).get(this.field);
            int[] highlightingBuffer = this.findHighlightPositions(searchValues, this.field, frag.value, fragmentValueLength);
            if (this.queryItemList.stream().allMatch(item -> (Boolean)item.second)) {
                this.updateHighlights(highlightingBuffer, index);
            }
            for (PGenericPair<List<String>, Boolean> item2 : this.queryItemList) {
                item2.second = false;
            }
        }
    }

    @Override
    public int[] findHighlightPositions(HighlightTokenContainer fragmentTokenContainer, String field, String fragmentValue, int fragmentValueLength) {
        int[] highlightingBuffer = new int[fragmentValueLength];
        Arrays.fill(highlightingBuffer, -1);
        try {
            this.phraseHighlight(fragmentTokenContainer, highlightingBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return highlightingBuffer;
    }

    public void phraseHighlight(HighlightTokenContainer fragmentTokenContainer, int[] highlightingBuffer) throws IOException {
        Int2ObjectOpenHashMap<HighlightTokenContainer.HighlightToken> foundFragments = new Int2ObjectOpenHashMap<HighlightTokenContainer.HighlightToken>();
        for (HighlightTokenContainer.HighlightToken fragmentToken : fragmentTokenContainer.tokens) {
            for (PGenericPair<List<String>, Boolean> pGenericPair : this.queryItemList) {
                for (String searchToken : (List)pGenericPair.first) {
                    if (!searchToken.equals(fragmentToken.term()) || highlightingBuffer[fragmentToken.startOffset()] >= fragmentToken.endOffset()) continue;
                    highlightingBuffer[fragmentToken.startOffset()] = fragmentToken.endOffset();
                    pGenericPair.second = true;
                    foundFragments.put(fragmentToken.startOffset(), fragmentToken);
                }
            }
        }
        if (foundFragments.size() == 0) {
            return;
        }
        ArrayList<HighlightTokenContainer.HighlightToken> sortedFragments = new ArrayList<HighlightTokenContainer.HighlightToken>(foundFragments.values());
        sortedFragments.sort(Comparator.comparingInt(HighlightTokenContainer.HighlightToken::startOffset));
        ArrayList<HighlightTokenContainer.HighlightToken> adjacentFragments = new ArrayList<HighlightTokenContainer.HighlightToken>();
        HighlightTokenContainer.HighlightToken previousFragment = null;
        for (HighlightTokenContainer.HighlightToken highlightToken : sortedFragments) {
            if (previousFragment != null && previousFragment.endOffset() >= highlightToken.startOffset() - 2) {
                String newTerm;
                if (previousFragment.endOffset() >= highlightToken.startOffset()) {
                    if (previousFragment.endOffset() < previousFragment.term().length()) {
                        newTerm = previousFragment.term().substring(0, previousFragment.endOffset());
                        newTerm = newTerm.concat(highlightToken.term());
                    } else if (previousFragment.endOffset() == highlightToken.startOffset()) {
                        newTerm = previousFragment.term();
                        newTerm = newTerm.concat(highlightToken.term());
                    } else {
                        if (previousFragment.term().startsWith(highlightToken.term()) || previousFragment.term().endsWith(highlightToken.term()) && previousFragment.endOffset() == highlightToken.endOffset()) continue;
                        newTerm = previousFragment.term().substring(0, highlightToken.startOffset() - previousFragment.startOffset());
                        newTerm = newTerm.concat(highlightToken.term());
                    }
                    if (newTerm.length() < previousFragment.term().length()) {
                        newTerm = newTerm.concat(previousFragment.term().substring(newTerm.length()));
                    }
                } else {
                    newTerm = previousFragment.term().concat(highlightToken.term());
                }
                previousFragment = new HighlightTokenContainer.HighlightToken(newTerm, previousFragment.startOffset(), highlightToken.endOffset(), previousFragment.completeWord() || highlightToken.completeWord());
                adjacentFragments.set(adjacentFragments.size() - 1, previousFragment);
                continue;
            }
            adjacentFragments.add(highlightToken);
            previousFragment = highlightToken;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HighlightTokenContainer.HighlightToken fragment : adjacentFragments) {
            arrayList.add(fragment.term());
        }
        ArrayList<HighlightTokenContainer.HighlightToken> arrayList2 = new ArrayList<HighlightTokenContainer.HighlightToken>();
        for (PGenericPair<List<String>, Boolean> itemListEntry : this.queryItemList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                int finalI = i;
                if (((List)itemListEntry.first).stream().anyMatch(entryString -> HighlightUtils.replaceUmlaut((String)adjacentFragmentStrings.get(finalI)).contains(HighlightUtils.replaceUmlaut(entryString)))) {
                    itemListEntry.second = true;
                    continue;
                }
                arrayList2.add((HighlightTokenContainer.HighlightToken)adjacentFragments.get(i));
            }
        }
        if (!arrayList2.isEmpty()) {
            adjacentFragments.removeAll(arrayList2);
        }
        HighlightUtils.mergeHighlightTokenPositions(highlightingBuffer, adjacentFragments);
    }

    private void processPhraseQueryElements() {
        boolean isNumericalPhraseQuery = true;
        int queryLength = -1;
        StringBuilder valueBuilder = new StringBuilder();
        for (PSolQueryItem item : this.phraseItem.getItemList()) {
            String[] relevantInformation = item.toString().split(":");
            String itemValue = "";
            if (relevantInformation.length == 1) {
                itemValue = relevantInformation[0];
            } else if (relevantInformation.length == 2) {
                itemValue = relevantInformation[1];
            }
            if (this.field.endsWith("_exact") || this.field.contains("cls_standards")) {
                queryLength = Math.max(queryLength, itemValue.length() + 1);
            }
            if (!itemValue.isEmpty()) {
                if (!valueBuilder.isEmpty()) {
                    valueBuilder.append(" ").append(itemValue);
                } else {
                    valueBuilder.append(itemValue);
                }
            }
            isNumericalPhraseQuery = isNumericalPhraseQuery && !Double.isNaN(NumUtils.getNumeric(itemValue));
        }
        this.value = valueBuilder.toString();
        if (this.parentRef != null) {
            if (this.field.endsWith("_lang")) {
                if (this.phraseItem.isStrict()) {
                    this.parentRef.hasStrictHighlightingNode = true;
                } else {
                    this.parentRef.hasPhraseHighlightingNode = true;
                }
            }
            this.parentRef.hasNumericalPhraseQuery = isNumericalPhraseQuery;
        }
    }

    @Override
    public void transmitNodes(IHighlightingInfoReceiver receiver) {
        this.parent.addFieldValue(this.field, this.value);
        receiver.receiveNode(this);
    }
}

