/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.HighlightingRequest;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightTokenContainer;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightUtils;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingAddressBook;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNodeStemmer;
import de.cadenas.catalogsearch.lucene.highlighting.IHighlightingInfoReceiver;
import de.cadenas.util.PIntPair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.lucene.search.BooleanClause;

public abstract class HighlightingNode {
    public static final int NON_VALID_INDEX = -1;
    public static final int INVALID_LENGTH = -1;
    public static final int LENGTH_ALLOWANCE = 2;
    Int2ObjectMap<Map<String, List<String>>> unStemmedLanguageValues = new Int2ObjectOpenHashMap<Map<String, List<String>>>();
    Map<String, List<String>> unStemmedNonLanguageValues = new HashMap<String, List<String>>();
    Int2ObjectMap<List<PIntPair>> highlightPositions = new Int2ObjectOpenHashMap<List<PIntPair>>();
    HighlightingAddressBook fragmentInventory;
    final HighlightingNodeStemmer stemmer = new HighlightingNodeStemmer();
    FieldDefinitions.LanguageGroup languageOfChoice = FieldDefinitions.LanguageGroup.Default;
    private final Collection<String> undesiredFieldStarters = new ArrayList<String>(Arrays.asList("col_text_unit", "col_text_attr_and_files"));
    BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
    HighlightingNode parent = null;
    final List<HighlightingNode> children = new ArrayList<HighlightingNode>();
    String field;
    String value;
    int queryLength = -1;
    boolean isTagCloud = false;
    boolean highlighted = false;
    boolean languageLocked = false;

    HighlightingNode() {
        this.field = "";
        this.value = "";
    }

    HighlightingNode(String field, String value, HighlightingNode parent) {
        this.field = field;
        this.value = value;
        this.addFieldValue(field, value);
        this.setParent(parent);
    }

    public boolean equals(HighlightingNode other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, new HashSet());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("value", (Object)this.value).append("field", (Object)this.field).append("highlighted", this.highlighted).append("occur", (Object)this.occur).append("queryLength", this.queryLength).append("highlightingPositions", this.highlightPositions.size()).toString();
    }

    public void detachFromParent() {
        this.parent.onChildDetached(this);
        this.setParent(null);
    }

    public void onChildDetached(HighlightingNode child) {
        this.children.remove(child);
        if (this.children.isEmpty() && this.parent != null) {
            this.detachFromParent();
        }
    }

    public void transmitNodes(IHighlightingInfoReceiver receiver) {
        if (this.filterNode()) {
            this.detachFromParent();
            return;
        }
        receiver.receiveNode(this);
    }

    public boolean filterNode() {
        return this.undesiredFieldStarters.stream().anyMatch(undesiredFieldStarter -> this.field.startsWith((String)undesiredFieldStarter));
    }

    public void setParent(HighlightingNode parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public void highlightWith(HighlightingAddressBook fragmentInventory) {
        this.fragmentInventory = fragmentInventory;
        this.resolveHighlightPositions();
    }

    public void resolveHighlightPositions() {
        for (String language : this.fragmentInventory.request.languageList) {
            this.languageOfChoice = FieldDefinitions.getLanguageGroup(language);
            this.highlight(this.stemmer.stemValues(this.unStemmedLanguageValues.getOrDefault(this.languageOfChoice.ordinal(), (Map<String, List<String>>)new HashMap()), this.fragmentInventory));
            if (!this.languageLocked) continue;
            break;
        }
        if (!this.languageLocked) {
            this.highlight(this.stemmer.stemValues(this.unStemmedNonLanguageValues, this.fragmentInventory));
        }
        this.highlighted = !this.highlightPositions.isEmpty();
    }

    public void organizePeers() {
        for (HighlightingNode child : this.children) {
            for (HighlightingNode otherChild : this.children) {
                if (child == otherChild || !child.equals(otherChild)) continue;
                otherChild.highlighted = otherChild.highlighted || child.highlighted;
            }
        }
    }

    public void highlight(Map<String, HighlightTokenContainer> valueMap) {
        for (Map.Entry<String, HighlightTokenContainer> entry : valueMap.entrySet()) {
            String valueField = entry.getKey();
            HighlightTokenContainer searchTerms = entry.getValue();
            IntList indices = this.fragmentInventory.getFragmentIndicesForLangField(this.languageOfChoice, valueField);
            if (indices == null) {
                indices = this.fragmentInventory.getFragmentIndicesForNonLangField(valueField);
            }
            if (indices == null) {
                return;
            }
            for (Integer index : indices) {
                int fragmentValueLength;
                HighlightingRequest.Fragment fragment = this.fragmentInventory.request.fragments.get(index);
                boolean validNode = this.attemptNodeHighlight(fragment, valueField, fragmentValueLength = fragment.value.length());
                if (!validNode) {
                    String reformattedField = !valueField.startsWith("col_text_tags_") ? HighlightUtils.removeLanguageGroup(valueField).replace("col_text_", "col_number_") : "col_text_";
                    validNode = this.attemptNodeHighlight(fragment, reformattedField, fragmentValueLength);
                }
                if (!validNode) continue;
                int[] highlightingBuffer = this.findHighlightPositions(searchTerms, valueField, fragment.value, fragmentValueLength);
                if (valueField.startsWith("col_number_") && Arrays.stream(highlightingBuffer).allMatch(v -> v == -1)) {
                    highlightingBuffer = this.findHighlightPositions(searchTerms, valueField.replace("col_number_", "col_text_"), fragment.value, fragmentValueLength);
                }
                this.updateHighlights(highlightingBuffer, index);
                this.languageLocked = this.languageLocked || Arrays.stream(highlightingBuffer).anyMatch(i -> i != -1);
            }
        }
    }

    public boolean attemptNodeHighlight(HighlightingRequest.Fragment frag, String field, int fragLength) {
        return this.fragAndFieldValueLengthValid(frag.value, field, fragLength) && (Arrays.asList(frag.fieldNames).contains(field) || field.equals("col_text_") && Arrays.stream(frag.fieldNames).anyMatch(lField -> lField.contains("col_text_")));
    }

    protected void updateHighlights(int[] highlightingBuffer, int fragIndex) {
        for (int i = 0; i < highlightingBuffer.length; ++i) {
            if (highlightingBuffer[i] == -1) continue;
            HighlightUtils.updateHighlightMap(this.highlightPositions, fragIndex, highlightingBuffer, i);
        }
    }

    public int[] findHighlightPositions(HighlightTokenContainer searchTerms, String field, String fragmentValue, int fragmentValueLength) {
        int[] highlightingBuffer = new int[fragmentValueLength];
        Arrays.fill(highlightingBuffer, -1);
        this.determineHighlightSpans(field, fragmentValue, searchTerms, highlightingBuffer);
        return highlightingBuffer;
    }

    public boolean fragAndFieldValueLengthValid(CharSequence value, CharSequence field, int valueLength) {
        return !value.isEmpty() && valueLength >= this.getQueryLength() && !field.isEmpty();
    }

    private void determineHighlightSpans(String field, String fragmentValue, HighlightTokenContainer stemmedSearchTerms, int[] previousIndexBuffer) {
        try {
            Object analyzableField = field;
            if (this.languageOfChoice != FieldDefinitions.LanguageGroup.Default && field.startsWith("col_text_")) {
                analyzableField = (String)analyzableField + "_" + this.languageOfChoice.toString().toLowerCase() + "_lang";
            }
            HighlightTokenContainer tokenContainer = HighlightTokenContainer.build(fragmentValue, (String)analyzableField, this.fragmentInventory);
            this.analyseFragmentStream(tokenContainer, stemmedSearchTerms, previousIndexBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void analyseFragmentStream(HighlightTokenContainer toolBox, HighlightTokenContainer stemmedSearchTerms, int[] previousIndexBuffer) throws IOException {
        this.standardHighlight(toolBox, stemmedSearchTerms, previousIndexBuffer);
    }

    private boolean validTermLength(HighlightTokenContainer.HighlightToken highlightToken) {
        return this.getQueryLength() - 2 <= highlightToken.length();
    }

    protected boolean matchHighlightCriteria(HighlightTokenContainer.HighlightToken searchToken, HighlightTokenContainer.HighlightToken fragmentToken, int[] highlightingBuffer) {
        if (!this.validTermLength(searchToken)) {
            return false;
        }
        if (highlightingBuffer[fragmentToken.startOffset()] >= fragmentToken.endOffset()) {
            return false;
        }
        String searchWord = searchToken.term();
        String fragmentWord = fragmentToken.term();
        double adjustmentFactor = 0.75;
        int searchLength = searchWord.length();
        double adjustedFragmentLength = (double)fragmentWord.length() * adjustmentFactor;
        boolean correctLength = !fragmentToken.completeWord() && fragmentWord.startsWith(searchWord) && (double)searchLength >= adjustedFragmentLength;
        return searchWord.equals(fragmentWord) || correctLength;
    }

    public void standardHighlight(HighlightTokenContainer fragmentTokenContainer, HighlightTokenContainer stemmedSearchTerms, int[] highlightingBuffer) {
        for (HighlightTokenContainer.HighlightToken fragmentToken : fragmentTokenContainer.tokens) {
            for (HighlightTokenContainer.HighlightToken searchToken : stemmedSearchTerms.tokens) {
                if (!this.matchHighlightCriteria(searchToken, fragmentToken, highlightingBuffer)) continue;
                highlightingBuffer[fragmentToken.startOffset()] = fragmentToken.endOffset();
            }
        }
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setQueryLength(int length) {
        if (length < this.queryLength) {
            return;
        }
        this.queryLength = length;
    }

    public int getQueryLength() {
        return this.queryLength;
    }

    public void addFieldValue(String field, String value) {
        if (field.endsWith("_lang")) {
            Map valueMap;
            FieldDefinitions.LanguageGroup lang = FieldDefinitions.getLanguageGroup(FieldDefinitions.getLanguageOfField(field));
            if (this.languageOfChoice == FieldDefinitions.LanguageGroup.Default) {
                this.languageOfChoice = lang;
            }
            if ((valueMap = (Map)this.unStemmedLanguageValues.getOrDefault(lang.ordinal(), (Map<String, List<String>>)new HashMap())).isEmpty()) {
                this.unStemmedLanguageValues.put(lang.ordinal(), (Map<String, List<String>>)valueMap);
            }
            HighlightUtils.putIntoListMap(valueMap, field, value);
        } else {
            HighlightUtils.putIntoListMap(this.unStemmedNonLanguageValues, field, value);
        }
    }
}

