/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.highlighting;

import de.cadenas.catalogsearch.HighlightingRequest;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightUtils;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingAddressBook;
import de.cadenas.catalogsearch.lucene.highlighting.HighlightingNode;
import de.cadenas.catalogsearch.lucene.highlighting.IHighlightingInfoReceiver;
import de.cadenas.catalogsearch.lucene.highlighting.QueryDecomposerFactory;
import de.cadenas.util.PIntPair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;

public final class HighlightingInfoReceiverImpl
implements IHighlightingInfoReceiver {
    private final HighlightingAddressBook highlightAddressBook;
    private final HighlightingRequest request;
    private final boolean activateBoolLogic;
    private HighlightingNode lastNode;
    private final RootHighlightingNode invisibleRootNode = new RootHighlightingNode();

    public HighlightingInfoReceiverImpl(Query query, HighlightingRequest req) {
        this.lastNode = this.invisibleRootNode;
        this.request = req;
        this.highlightAddressBook = new HighlightingAddressBook(req);
        this.activateBoolLogic = this.useBooleanLogic(req);
        QueryDecomposerFactory.decompose(query, (IHighlightingInfoReceiver)this, (HighlightingNode)this.invisibleRootNode);
        this.invisibleRootNode.gatherHighlightingFromChildren();
    }

    private boolean useBooleanLogic(HighlightingRequest req) {
        for (HighlightingRequest.Fragment fragment : req.fragments) {
            for (String field : fragment.fieldNames) {
                if (field.equals("col_text_tags") || field.equals("catalog") || field.startsWith("nn") || field.startsWith("nt") || field.startsWith("nb")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void receiveNode(HighlightingNode node) {
        this.processNode(node);
        this.lastNode = node;
    }

    @Override
    public void setLastNodeOccur(BooleanClause.Occur occur) {
        if (!this.lastNode.isTagCloud) {
            this.lastNode.occur = occur;
        }
    }

    public void processNode(HighlightingNode node) {
        node.highlightWith(this.highlightAddressBook);
    }

    private String highlightFragmentValue(int fragmentIndex, String fragmentValue) {
        List highlightSpans = (List)this.invisibleRootNode.highlightPositions.get(fragmentIndex);
        highlightSpans.sort(Comparator.comparingInt(n -> n.first));
        StringBuilder builder = new StringBuilder();
        int lastSpanEnd = 0;
        for (PIntPair span : highlightSpans) {
            if (lastSpanEnd < span.first) {
                builder.append(fragmentValue, lastSpanEnd, span.first);
            }
            builder.append(this.request.preTag).append(fragmentValue, span.first, span.second).append(this.request.postTag);
            lastSpanEnd = span.second;
        }
        if (lastSpanEnd < fragmentValue.length()) {
            builder.append(fragmentValue, lastSpanEnd, fragmentValue.length());
        }
        return builder.toString();
    }

    public List<String> getHighlightedFragments() {
        ArrayList<String> result = new ArrayList<String>();
        for (int fragmentIndex = 0; fragmentIndex < this.request.fragments.size(); ++fragmentIndex) {
            HighlightingRequest.Fragment fragment = this.request.fragments.get(fragmentIndex);
            if (this.invisibleRootNode.highlightPositions.containsKey(fragmentIndex)) {
                result.add(this.highlightFragmentValue(fragmentIndex, fragment.value));
                continue;
            }
            result.add(fragment.value);
        }
        return result;
    }

    @Override
    public boolean isBoolLogicActivated() {
        return this.activateBoolLogic;
    }

    @Override
    public boolean highlightingFinished() {
        return this.invisibleRootNode.children.stream().allMatch(HighlightingNode::isHighlighted);
    }

    private static class RootHighlightingNode
    extends HighlightingNode {
        private RootHighlightingNode() {
        }

        public void gatherHighlightingFromChildren() {
            ArrayList<Int2ObjectMap.Entry<List<PIntPair>>> positions = new ArrayList<Int2ObjectMap.Entry<List<PIntPair>>>();
            for (HighlightingNode child : this.children) {
                Int2ObjectMap<List<PIntPair>> childPositions = child.highlightPositions;
                if (childPositions == null || childPositions.int2ObjectEntrySet().isEmpty()) continue;
                positions.addAll(child.highlightPositions.int2ObjectEntrySet());
            }
            HighlightUtils.addNotPresentPositions(positions, this.highlightPositions);
        }
    }
}

