/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.fields;

import de.cadenas.catalogsearch.lucene.analysis.filter.AppendModeFilter;
import de.cadenas.catalogsearch.lucene.fields.PSolFieldBase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;

public final class PSolTextField
extends PSolFieldBase {
    boolean appendMode = false;

    public PSolTextField(String name, String value, Field.Store store) {
        super(name, value, store);
    }

    @Override
    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        TokenStream result = super.tokenStream(analyzer, reuse);
        if (result instanceof AppendModeFilter) {
            AppendModeFilter filter = (AppendModeFilter)result;
            filter.setAppendMode(this.appendMode);
        }
        return result;
    }

    public void setAppendMode(boolean yesno) {
        this.appendMode = true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSolTextField other = (PSolTextField)obj;
        if (!this.name().equals(other.name()) || !this.fieldType().equals(other.fieldType())) {
            return false;
        }
        CharSequence csThis = this.getCharSequenceValue();
        CharSequence csOther = this.getCharSequenceValue();
        if (csThis == null || csOther == null) {
            return false;
        }
        return csThis.equals(csOther);
    }

    public int hashCode() {
        int result = this.name().hashCode();
        CharSequence cs = this.getCharSequenceValue();
        if (cs != null) {
            result = result * 31 + cs.hashCode();
        }
        return result;
    }
}

