/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;

public class PSolMultiFacets
extends Facets {
    private final Map<String, Facets> dimToFacets;
    private final Facets commonFacets;
    private final Facets varFacets;
    private final Facets filterAssistantFacets;

    public PSolMultiFacets(Map<String, Facets> dimToFacets) {
        this(dimToFacets, null, null, null);
    }

    public PSolMultiFacets(Map<String, Facets> dimToFacets, Facets commonFacets, Facets varFacets, Facets filterAssistantFacets) {
        this.dimToFacets = dimToFacets;
        this.commonFacets = commonFacets;
        this.varFacets = varFacets;
        this.filterAssistantFacets = filterAssistantFacets;
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        Facets facets = this.dimToFacets.get(dim);
        if (facets != null) {
            return facets.getTopChildren(topN, dim, path);
        }
        FacetResult ret = null;
        if (this.commonFacets != null) {
            ret = this.commonFacets.getTopChildren(topN, dim, path);
        }
        if (ret == null && this.varFacets != null) {
            ret = this.varFacets.getTopChildren(topN, dim, path);
        }
        if (ret == null && this.filterAssistantFacets != null) {
            ret = this.filterAssistantFacets.getTopChildren(topN, dim, path);
        }
        return ret;
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        Facets facets = this.dimToFacets.get(dim);
        if (facets != null) {
            return facets.getSpecificValue(dim, path);
        }
        Number ret = 0;
        if (this.commonFacets != null) {
            ret = this.commonFacets.getSpecificValue(dim, path);
        }
        if (ret == 0 && this.varFacets != null) {
            ret = this.varFacets.getSpecificValue(dim, path);
        }
        if (ret == 0 && this.filterAssistantFacets != null) {
            ret = this.filterAssistantFacets.getSpecificValue(dim, path);
        }
        return ret;
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        for (Map.Entry<String, Facets> ent : this.dimToFacets.entrySet()) {
            FacetResult res = ent.getValue().getTopChildren(topN, ent.getKey(), new String[0]);
            if (res == null) continue;
            results.add(res);
        }
        if (this.commonFacets != null) {
            for (FacetResult result : this.commonFacets.getAllDims(topN)) {
                if (this.dimToFacets.containsKey(result.dim)) continue;
                results.add(result);
            }
        }
        if (this.varFacets != null) {
            for (FacetResult result : this.varFacets.getAllDims(topN)) {
                if (this.dimToFacets.containsKey(result.dim)) continue;
                results.add(result);
            }
        }
        if (this.filterAssistantFacets != null) {
            for (FacetResult result : this.filterAssistantFacets.getAllDims(topN)) {
                if (this.dimToFacets.containsKey(result.dim)) continue;
                results.add(result);
            }
        }
        return results;
    }
}

