/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.facet;

import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.LuceneSearchService;
import de.cadenas.util.PLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.CompositeReader;

public class FacetStateProvider {
    private final IIndexManager indexManager;
    private final IIndexManager.IndexSearcherContainer container;
    private static final PLogger logger = new PLogger(LuceneSearchService.class.getSimpleName());

    public FacetStateProvider(IIndexManager indexManager, IIndexManager.IndexSearcherContainer container) {
        this.indexManager = indexManager;
        this.container = container;
    }

    public SortedSetDocValuesReaderState getCommonState() throws IOException {
        return this.indexManager.createReaderState(this.container.getIndexReader(), this.container.indexType, FieldDefinitions.FacetType.FacetCommon);
    }

    public SortedSetDocValuesReaderState getFilterAssistantState() throws IOException {
        return this.indexManager.createReaderState(this.container.getIndexReader(), this.container.indexType, FieldDefinitions.FacetType.FacetFilterAssistant);
    }

    public StateObject getVariableState(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        ArrayList<FacetsCollector.MatchingDocs> readerDocs = null;
        CompositeReader singleReader = null;
        for (FacetsCollector.MatchingDocs docs : matchingDocs) {
            if (docs.totalHits <= 0) continue;
            CompositeReader reader = docs.context.parent.reader();
            if (singleReader == null) {
                singleReader = reader;
                readerDocs = new ArrayList<FacetsCollector.MatchingDocs>();
                readerDocs.add(docs);
                continue;
            }
            if (singleReader != reader) {
                return null;
            }
            readerDocs.add(docs);
        }
        if (singleReader != null) {
            SortedSetDocValuesReaderState state = this.indexManager.createReaderState(singleReader, this.container.indexType, FieldDefinitions.FacetType.FacetVariable);
            if (state == null) {
                String catalogname;
                IIndexManager.IIndexReaderData readerData = this.indexManager.findReaderData(singleReader);
                if (readerData != null && (catalogname = readerData.getCatalogName()) != null) {
                    logger.error("can not get variable facets for " + catalogname);
                    return null;
                }
                logger.error("can not get variable facets");
                return null;
            }
            return new StateObject(state, readerDocs);
        }
        return null;
    }

    public static String getCommonCatalogName(List<FacetsCollector.MatchingDocs> matchingDocs, IIndexManager indexManager) {
        IIndexManager.IIndexReaderData readerData;
        CompositeReader singleReader = null;
        for (FacetsCollector.MatchingDocs docs : matchingDocs) {
            if (docs.totalHits <= 0) continue;
            CompositeReader reader = docs.context.parent.reader();
            if (singleReader == null) {
                singleReader = reader;
                continue;
            }
            if (singleReader == reader) continue;
            return "";
        }
        if (singleReader != null && (readerData = indexManager.findReaderData(singleReader)) != null) {
            return readerData.getCatalogName();
        }
        return null;
    }

    public record StateObject(SortedSetDocValuesReaderState state, List<FacetsCollector.MatchingDocs> docs) {
    }
}

