/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.facet;

import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.lucene.facet.FacetStateProvider;
import de.cadenas.catalogsearch.lucene.facet.IFacetListBuilder;
import de.cadenas.catalogsearch.lucene.facet.PFacetCounts;
import de.cadenas.catalogsearch.lucene.search.FacetCountingFilter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;

public class DefaultFacetListBuilder
implements IFacetListBuilder {
    private final IIndexManager indexManager;
    private final IIndexManager.IndexSearcherContainer container;
    private final List<FacetsCollector.MatchingDocs> matchingDocs;
    private final FacetCountingFilter facetFilter;
    private final int facetTypes;
    private final boolean optimizedFacetCounter;
    private final ExecutorService executorService;

    public DefaultFacetListBuilder(IIndexManager indexManager, IIndexManager.IndexSearcherContainer container, List<FacetsCollector.MatchingDocs> matchingDocs, FacetCountingFilter facetFilter, int facetTypes, boolean optimizedFacetCounter, ExecutorService executorService) {
        this.indexManager = indexManager;
        this.container = container;
        this.matchingDocs = matchingDocs;
        this.facetFilter = facetFilter;
        this.facetTypes = facetTypes;
        this.optimizedFacetCounter = optimizedFacetCounter;
        this.executorService = executorService;
    }

    @Override
    public IFacetListBuilder.Result buildResults(boolean loadVariableFacets, boolean loadFilterFacets) {
        IFacetListBuilder.Result result = new IFacetListBuilder.Result();
        try {
            FacetStateProvider facetProvider = new FacetStateProvider(this.indexManager, this.container);
            FacetStateProvider.StateObject[] readerStates = new FacetStateProvider.StateObject[3];
            if ((this.facetTypes & 1) != 0) {
                readerStates[0] = new FacetStateProvider.StateObject(facetProvider.getCommonState(), this.matchingDocs);
            }
            if ((this.facetTypes & 2) != 0 && loadVariableFacets) {
                readerStates[1] = facetProvider.getVariableState(this.matchingDocs);
            }
            if ((this.facetTypes & 4) != 0) {
                readerStates[2] = new FacetStateProvider.StateObject(facetProvider.getFilterAssistantState(), this.matchingDocs);
            }
            for (int i = 0; i < readerStates.length; ++i) {
                FacetStateProvider.StateObject stateObject = readerStates[i];
                try {
                    if (stateObject == null || stateObject.state() == null) continue;
                    boolean optimized = this.optimizedFacetCounter && i == 0;
                    PFacetCounts facets = new PFacetCounts(stateObject.state(), stateObject.docs(), this.facetFilter, optimized, null, this.executorService);
                    List<FacetResult> facetResults = ((Facets)facets).getAllDims(10000);
                    result.facetResults.add(facetResults);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

