/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.helper;

import java.util.ArrayList;
import java.util.List;

public class Varset {
    private List<String> namesAndValues = new ArrayList<String>();

    private void separateVarset(String varset) {
        if (varset == null) {
            return;
        }
        int len = varset.length();
        for (int i = 0; i < len; ++i) {
            char quote2 = '\u0000';
            StringBuilder name = new StringBuilder();
            StringBuilder value = new StringBuilder();
            while (i < len && varset.charAt(i) == ' ' || varset.charAt(i) == ',') {
                ++i;
            }
            if (i < len && varset.charAt(i) == '\"' || varset.charAt(i) == '{') {
                if (varset.charAt(i) == '\"') {
                    quote2 = '\"';
                } else if (varset.charAt(i) == '{') {
                    quote2 = '}';
                }
                ++i;
                while (i < len && varset.charAt(i) != '=') {
                    name.append(varset.charAt(i++));
                }
                if (i < len && varset.charAt(i) == '=') {
                    ++i;
                    boolean end = false;
                    boolean slash = false;
                    while (!end && i < len) {
                        if (!slash) {
                            if (varset.charAt(i) == '\\') {
                                slash = true;
                            } else if (varset.charAt(i) == quote2) {
                                end = true;
                            } else {
                                value.append(varset.charAt(i));
                            }
                        } else {
                            slash = false;
                            value.append(varset.charAt(i));
                        }
                        ++i;
                    }
                }
                if (name.length() <= 0) continue;
                this.namesAndValues.add(name.toString());
                this.namesAndValues.add(value.toString());
                continue;
            }
            while (i < len && varset.charAt(i) != ',') {
                ++i;
            }
        }
    }

    public Varset() {
    }

    public Varset(String varset) {
        this.separateVarset(varset);
    }

    public void addVarValue(String name, String value) {
        for (int i = 0; i < this.namesAndValues.size(); i += 2) {
            if (!this.namesAndValues.get(i).equals(name)) continue;
            this.namesAndValues.set(i + 1, value);
            return;
        }
        this.namesAndValues.add(name);
        this.namesAndValues.add(value);
    }

    public String makeVarset() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.namesAndValues.size(); i += 2) {
            String varName = this.namesAndValues.get(i);
            String internalValue = this.namesAndValues.get(i + 1);
            if (varName == null || internalValue == null) continue;
            sb.append('{');
            sb.append(varName);
            sb.append('=');
            sb.append(internalValue);
            sb.append('}');
            if (i >= this.namesAndValues.size() - 2) continue;
            sb.append(',');
        }
        return sb.toString();
    }
}

