/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public class ZeroFilter
extends TokenFilter {
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);
    private final CharTermAttribute termAttr = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAttr = this.addAttribute(OffsetAttribute.class);

    public ZeroFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.keywordAttr.isKeyword()) {
                return true;
            }
            char[] buffer = this.termAttr.buffer();
            int length = this.termAttr.length();
            boolean isNumber = false;
            int pos = 0;
            for (int i = 0; i < length; ++i) {
                char c = buffer[i];
                if (c == '0') {
                    ++pos;
                    continue;
                }
                if (c <= '0' || c > '9') break;
                isNumber = true;
                break;
            }
            if (pos > 0 && isNumber) {
                this.termAttr.copyBuffer(buffer, pos, this.termAttr.length() - pos);
                this.offsetAttr.setOffset(this.offsetAttr.startOffset() + pos, this.offsetAttr.endOffset());
            }
            return true;
        }
        return false;
    }
}

