/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

public final class WordDelimiterIterator {
    private static final int LETTER = 1;
    private static final int DIGIT = 4;
    public static final int SUBWORD_DELIM = 8;
    private static final int WILDCARD = 16;
    private static final int SQUOTE = 32;
    static final int DONE = -1;
    public static final byte[] DEFAULT_WORD_DELIM_TABLE;
    private char[] text;
    private int length;
    private int startBounds;
    private int endBounds;
    int current;
    int end;
    boolean hasFinalPossessive = false;
    boolean hasWildcard = false;
    private final boolean keepEnglishPossessive;
    private final boolean keepWildcards;
    private final byte[] charTypeTable = DEFAULT_WORD_DELIM_TABLE;

    WordDelimiterIterator(boolean keepEnglishPossessive, boolean keepWildcards) {
        this.keepEnglishPossessive = keepEnglishPossessive;
        this.keepWildcards = keepWildcards;
    }

    int next() {
        this.hasWildcard = false;
        this.current = this.end;
        if (this.current == -1) {
            return -1;
        }
        int lastType = 0;
        while (this.current < this.endBounds && WordDelimiterIterator.isSubwordDelim(lastType = this.charType(this.text[this.current]))) {
            ++this.current;
        }
        if (this.current >= this.endBounds) {
            this.end = -1;
            return -1;
        }
        this.end = this.current + 1;
        while (this.end < this.endBounds) {
            int type = this.charType(this.text[this.end]);
            if (this.keepWildcards && WordDelimiterIterator.isWildcard(type)) {
                this.hasWildcard = true;
            } else {
                if (this.keepEnglishPossessive && WordDelimiterIterator.isApostrophe(type) && this.endsWithPossessive(this.end)) {
                    this.hasFinalPossessive = true;
                    this.end += 2;
                    break;
                }
                if (lastType != 16 && this.isBreak(lastType, type)) break;
                lastType = type;
            }
            ++this.end;
        }
        return this.end;
    }

    int type() {
        if (this.end == -1) {
            return 0;
        }
        return this.charType(this.text[this.current]);
    }

    void setText(char[] text, int length) {
        this.text = text;
        this.length = this.endBounds = length;
        this.end = 0;
        this.startBounds = 0;
        this.current = 0;
        this.hasFinalPossessive = false;
        this.setBounds();
    }

    private boolean isBreak(int lastType, int type) {
        return (type & lastType) == 0;
    }

    boolean isSingleWord() {
        return this.current == this.startBounds && this.end == this.endBounds;
    }

    private void setBounds() {
        while (this.startBounds < this.length && WordDelimiterIterator.isSubwordDelim(this.charType(this.text[this.startBounds]))) {
            ++this.startBounds;
        }
        while (this.endBounds > this.startBounds && WordDelimiterIterator.isSubwordDelim(this.charType(this.text[this.endBounds - 1]))) {
            --this.endBounds;
        }
        this.current = this.startBounds;
    }

    private boolean endsWithPossessive(int pos) {
        return !(pos + 1 >= this.endBounds || this.text[pos + 1] != 's' && this.text[pos + 1] != 'S' || pos + 2 != this.endBounds && !WordDelimiterIterator.isSubwordDelim(this.charType(this.text[pos + 2])));
    }

    private int charType(int ch) {
        if (ch < this.charTypeTable.length) {
            byte type = this.charTypeTable[ch];
            if (type == 16 && !this.keepWildcards) {
                return 8;
            }
            if (type == 32 && !this.keepEnglishPossessive) {
                return 8;
            }
            return type;
        }
        return WordDelimiterIterator.getType(ch);
    }

    private static byte getType(int ch) {
        switch (Character.getType(ch)) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 1;
            }
            case 9: 
            case 10: 
            case 11: {
                return 4;
            }
            case 19: {
                return 5;
            }
        }
        return 8;
    }

    static boolean isAlpha(int type) {
        return (type & 1) != 0;
    }

    static boolean isDigit(int type) {
        return (type & 4) != 0;
    }

    private static boolean isSubwordDelim(int type) {
        return (type & 8) != 0;
    }

    static boolean isWildcard(int type) {
        return (type & 0x10) != 0;
    }

    private static boolean isApostrophe(int type) {
        return (type & 0x20) != 0;
    }

    static {
        byte[] tab = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byte code = 0;
            if (Character.isLowerCase(i)) {
                code = (byte)(code | 1);
            } else if (Character.isUpperCase(i)) {
                code = (byte)(code | 1);
            } else if (Character.isDigit(i)) {
                code = (byte)(code | 4);
            }
            if (code == 0) {
                code = (byte)8;
            }
            tab[i] = code;
        }
        DEFAULT_WORD_DELIM_TABLE = tab;
        WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE[63] = 16;
        WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE[42] = 16;
        WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE[39] = 32;
    }
}

