/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

import de.cadenas.catalogsearch.lucene.analysis.helper.TokenFlags;
import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public class WildcardFilter
extends TokenFilter {
    private final CharTermAttribute termAttr = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttribute = this.addAttribute(KeywordAttribute.class);
    private final FlagsAttribute flagsAttr = this.addAttribute(FlagsAttribute.class);

    public WildcardFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.containsWildcard(this.termAttr.buffer(), this.termAttr.length())) {
                this.keywordAttribute.setKeyword(true);
                TokenFlags.setFlag(TokenFlags.Flag.WildcardToken, this.flagsAttr);
            }
            return true;
        }
        return false;
    }

    private boolean containsWildcard(char[] text, int textLength) {
        for (int i = 0; i < textLength; ++i) {
            if (text[i] != '?' && text[i] != '*') continue;
            return true;
        }
        return false;
    }
}

