/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

import de.cadenas.catalogsearch.lucene.analysis.helper.TokenFlags;
import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;

public class DuplicateTokenFilter
extends TokenFilter {
    private boolean repeatToken;
    private AttributeSource.State current;
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final FlagsAttribute flagsAttr = this.addAttribute(FlagsAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public DuplicateTokenFilter(TokenStream in) {
        super(in);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.repeatToken) {
            this.repeatToken = false;
            this.restoreState(this.current);
            this.posIncAtt.setPositionIncrement(0);
            TokenFlags.setFlag(TokenFlags.Flag.ModToken, this.flagsAttr);
            TokenFlags.setFlag(TokenFlags.Flag.DupToken, this.flagsAttr);
            return true;
        }
        if (this.input.incrementToken()) {
            if (this.keywordAttr.isKeyword()) {
                TokenFlags.setFlag(TokenFlags.Flag.ExactToken, this.flagsAttr);
                return true;
            }
            this.current = this.captureState();
            this.repeatToken = true;
            this.keywordAttr.setKeyword(true);
            TokenFlags.setFlag(TokenFlags.Flag.ExactToken, this.flagsAttr);
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.repeatToken = false;
    }
}

