/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.BytesRef;

public class DebugPrintTermFilter
extends TokenFilter {
    private final CharTermAttribute termAttr = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAttr = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posAttr = this.addAttribute(PositionIncrementAttribute.class);
    private final FlagsAttribute flagsAttr = this.addAttribute(FlagsAttribute.class);
    private final PayloadAttribute payloadAttr = this.addAttribute(PayloadAttribute.class);
    private String fieldname;
    private static final ThreadLocal<ThreadData> tdata = new ThreadLocal<ThreadData>(){

        @Override
        protected ThreadData initialValue() {
            return new ThreadData();
        }
    };

    public DebugPrintTermFilter(String fullFieldName, TokenStream input) {
        super(input);
        this.fieldname = fullFieldName;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            PrintStream pout = DebugPrintTermFilter.tdata.get().pout;
            pout.print("[inc=" + this.posAttr.getPositionIncrement() + "] ");
            pout.print("[offset=" + this.offsetAttr.startOffset() + "-" + this.offsetAttr.endOffset() + "] ");
            pout.print("[flags=" + this.flagsAttr.getFlags() + "] ");
            BytesRef payLoad = this.payloadAttr.getPayload();
            if (payLoad != null) {
                pout.print("[pay=" + payLoad.toString() + "] ");
            }
            pout.print("[" + this.fieldname + "]");
            pout.print(String.valueOf(this.termAttr.buffer(), 0, this.termAttr.length()));
            pout.println("");
            return true;
        }
        return false;
    }

    public static class ThreadData {
        public OutputStream out = null;
        public PrintStream pout = null;

        public ThreadData() {
            try {
                Path tmpFilePath = Files.createTempFile("searchv2-terms", null, new FileAttribute[0]);
                this.out = new FileOutputStream(tmpFilePath.toFile());
                this.pout = new PrintStream(this.out, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

