/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis.filter;

import de.cadenas.catalogsearch.lucene.analysis.helper.TokenFlags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.analysis.CharArrayMap;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.CharsRef;

public class CompoundWordTokenFilter
extends TokenFilter {
    private final CharArrayMap<char[]> dictionary;
    private final CharArrayMap<char[]> synDictionary;
    private final List<List<CompoundToken>> ctokens;
    private List<CharsRef> stemmedText = null;
    private List<CharsRef> synonymText = null;
    private int tokenIndex;
    private int tokenSubIndex;
    private boolean inIndexMode;
    private boolean isPrefixQuery;
    private boolean repeatToken;
    private int currentPosition;
    private int expectedPosition;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final FlagsAttribute flagsAttr = this.addAttribute(FlagsAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);
    private AttributeSource.State current;

    public CompoundWordTokenFilter(TokenStream input, CharArrayMap<char[]> dictionary, CharArrayMap<char[]> synDictionary, boolean inIndexMode, boolean isPrefixQuery) {
        super(input);
        this.ctokens = new ArrayList<List<CompoundToken>>();
        this.dictionary = dictionary;
        this.synDictionary = synDictionary;
        this.tokenIndex = 0;
        this.tokenSubIndex = 0;
        this.inIndexMode = inIndexMode;
        this.isPrefixQuery = isPrefixQuery;
        this.repeatToken = false;
        this.currentPosition = -1;
        this.expectedPosition = 0;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.repeatToken) {
            this.repeatToken = false;
            this.restoreState(this.current);
            TokenFlags.setFlag(TokenFlags.Flag.ModToken, this.flagsAttr);
            TokenFlags.setFlag(TokenFlags.Flag.DupToken, this.flagsAttr);
            TokenFlags.setFlag(TokenFlags.Flag.CompleteWord, this.flagsAttr);
            this.adaptPositionIncrement();
            return true;
        }
        if (this.takeSynToken()) {
            TokenFlags.setFlag(TokenFlags.Flag.CompleteWord, this.flagsAttr);
            this.adaptPositionIncrement();
            return true;
        }
        if (this.takeStemmedToken()) {
            TokenFlags.setFlag(TokenFlags.Flag.CompleteWord, this.flagsAttr);
            this.adaptPositionIncrement();
            return true;
        }
        if (this.takeNextToken()) {
            this.adaptPositionIncrement();
            return true;
        }
        this.current = null;
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                this.decompose();
                this.current = this.captureState();
                if (this.stemmedText == null) {
                    this.repeatToken = true;
                }
            }
            this.expectedPosition = this.expectedPosition - this.expectedPosition % 100 + 100;
            this.keywordAttr.setKeyword(true);
            TokenFlags.setFlag(TokenFlags.Flag.ExactToken, this.flagsAttr);
            TokenFlags.setFlag(TokenFlags.Flag.CompleteWord, this.flagsAttr);
            this.adaptPositionIncrement();
            return true;
        }
        this.posIncAtt.setPositionIncrement(0);
        return false;
    }

    private boolean takeStemmedToken() {
        if (this.stemmedText != null) {
            this.restoreState(this.current);
            CharsRef item = this.stemmedText.remove(0);
            if (this.stemmedText.isEmpty()) {
                this.stemmedText = null;
            }
            this.termAtt.copyBuffer(item.chars, item.offset, item.length);
            TokenFlags.setFlag(TokenFlags.Flag.ModToken, this.flagsAttr);
            return true;
        }
        return false;
    }

    private boolean takeSynToken() {
        if (this.synonymText != null) {
            this.restoreState(this.current);
            CharsRef item = this.synonymText.remove(0);
            if (this.synonymText.isEmpty()) {
                this.synonymText = null;
            }
            this.termAtt.copyBuffer(item.chars, item.offset, item.length);
            TokenFlags.setFlag(TokenFlags.Flag.SynonymToken, this.flagsAttr);
            TokenFlags.setFlag(TokenFlags.Flag.ExactToken, this.flagsAttr);
            this.keywordAttr.setKeyword(true);
            return true;
        }
        return false;
    }

    private boolean takeNextToken() {
        if (this.ctokens.isEmpty()) {
            return false;
        }
        if (this.expectedPosition % 100 == 0) {
            ++this.expectedPosition;
        }
        while (true) {
            if (this.tokenIndex >= this.ctokens.size()) {
                this.ctokens.clear();
                this.tokenIndex = 0;
                this.tokenSubIndex = 0;
                return false;
            }
            if (this.tokenSubIndex < this.ctokens.get(this.tokenIndex).size()) break;
            this.expectedPosition = this.expectedPosition % 2 == 0 ? ++this.expectedPosition : (this.expectedPosition += 2);
            ++this.tokenIndex;
            this.tokenSubIndex = 0;
        }
        assert (this.current != null);
        this.restoreState(this.current);
        CompoundToken token = this.ctokens.get(this.tokenIndex).get(this.tokenSubIndex);
        int startOffset = this.offsetAtt.startOffset() + token.offset;
        if (token.stemmed != null) {
            this.termAtt.copyBuffer(token.stemmed, 0, token.stemmed.length);
            this.offsetAtt.setOffset(startOffset, startOffset + token.stemmed.length);
            if (!token.exactToken) {
                TokenFlags.setFlag(TokenFlags.Flag.ModToken, this.flagsAttr);
            }
        } else {
            char[] buffer = this.termAtt.buffer();
            this.termAtt.copyBuffer(buffer, token.bgn, token.length);
            this.offsetAtt.setOffset(startOffset, startOffset + token.length);
        }
        if (token.exactToken) {
            if (token.dupState == CompoundToken.DuplicateState.DupCopy) {
                TokenFlags.setFlag(TokenFlags.Flag.ModToken, this.flagsAttr);
                TokenFlags.setFlag(TokenFlags.Flag.DupToken, this.flagsAttr);
            } else {
                TokenFlags.setFlag(TokenFlags.Flag.ExactToken, this.flagsAttr);
                this.keywordAttr.setKeyword(true);
            }
        }
        if (token.lowPrioToken) {
            TokenFlags.setFlag(TokenFlags.Flag.LowPrioToken, this.flagsAttr);
        }
        if (token.leaf && this.expectedPosition % 2 == 1) {
            ++this.expectedPosition;
        }
        TokenFlags.setFlag(TokenFlags.Flag.CompoundPart, this.flagsAttr);
        if (token.dupState != CompoundToken.DuplicateState.DupExact) {
            ++this.tokenSubIndex;
        }
        if (token.dupState == CompoundToken.DuplicateState.DupExact) {
            token.dupState = CompoundToken.DuplicateState.DupCopy;
        } else if (token.dupState == CompoundToken.DuplicateState.DupCopy) {
            token.dupState = CompoundToken.DuplicateState.DupNone;
        }
        return true;
    }

    private void decompose() {
        char[] syn;
        char[] stemmed;
        char[] textAsChar = this.termAtt.buffer();
        if (!this.isPrefixQuery && (stemmed = this.stemText(textAsChar, 0, this.termAtt.length())) != null && stemmed.length > 0) {
            CharsRef stemmedWord = new CharsRef();
            while (CompoundWordTokenFilter.nextSubWord(stemmed, '\t', stemmedWord)) {
                if (CompoundWordTokenFilter.equalsIgnoreCase(stemmedWord.chars, stemmedWord.offset, stemmedWord.length, textAsChar, 0, this.termAtt.length())) continue;
                if (this.stemmedText == null) {
                    this.stemmedText = new ArrayList<CharsRef>();
                }
                this.stemmedText.add(stemmedWord);
            }
        }
        if (!this.inIndexMode && (syn = this.getSynonym(textAsChar, 0, this.termAtt.length())) != null && syn.length > 0) {
            CharsRef subWord = new CharsRef();
            while (CompoundWordTokenFilter.nextSubWord(syn, '\t', subWord)) {
                if (this.synonymText == null) {
                    this.synonymText = new ArrayList<CharsRef>();
                }
                this.synonymText.add(subWord);
            }
        }
        ComposeItem[] cItems = new ComposeItem[2];
        ComposeItem citem = cItems[0] = new ComposeItem();
        citem.root = new CompoundItem(CompoundItem.Type.Root, -1, -1);
        citem.found = CompoundWordTokenFilter.searchFromBegin(textAsChar, this.termAtt.length(), 0, this.dictionary, citem.root);
        if (!this.isPrefixQuery) {
            this.removeStemmedSuffix(citem.root, textAsChar);
        }
        citem.root.evaluateExactMatch();
        if (this.inIndexMode) {
            citem = cItems[1] = new ComposeItem();
            citem.inverse = true;
            citem.root = new CompoundItem(CompoundItem.Type.Root, -1, -1);
            citem.found = CompoundWordTokenFilter.searchFromEnd(textAsChar, 0, this.termAtt.length(), this.dictionary, citem.root);
            citem.root.evaluateExactMatch();
            citem.root.disableExactMatch();
            citem.root.removeExactFlag();
            if (!cItems[0].root.exact) {
                citem.root.markLongestMatch();
            }
            this.getTokens(this.ctokens, cItems[0].root, false, false, false);
            ArrayList<List<CompoundToken>> invTokens = new ArrayList<List<CompoundToken>>();
            this.getTokensInverse(invTokens, cItems[1].root);
            this.mergeTokenList(this.ctokens, invTokens);
        } else {
            citem = cItems[0];
            if (citem.root.exact || this.isPrefixQuery) {
                this.getBestTokens(this.ctokens, citem.root, textAsChar, 0, citem.root.exact, !citem.root.exact);
            }
        }
        this.cleanupExactTokens();
        this.fixTokenOffset();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.ctokens.clear();
        this.tokenIndex = 0;
        this.tokenSubIndex = 0;
        this.current = null;
        this.repeatToken = false;
        this.stemmedText = null;
        if (this.currentPosition == -1 || !TokenFlags.isSet(TokenFlags.Flag.AppendMode, this.flagsAttr)) {
            this.currentPosition = -1;
            this.expectedPosition = this.currentPosition + 10000;
        } else {
            ++this.currentPosition;
            this.expectedPosition = this.currentPosition + 100;
        }
    }

    private void adaptPositionIncrement() {
        this.posIncAtt.setPositionIncrement(this.expectedPosition - this.currentPosition);
        this.currentPosition = this.expectedPosition;
    }

    private static boolean equalsIgnoreCase(char[] a, int posA, int lenA, char[] b, int posB, int lenB) {
        if (a == null || b == null) {
            return false;
        }
        if (lenA != lenB) {
            return false;
        }
        for (int i = 0; i < lenA; ++i) {
            if (Character.toLowerCase(a[i + posA]) == Character.toLowerCase(b[i + posB])) continue;
            return false;
        }
        return true;
    }

    private static boolean containsIgnoreCase(List<CharsRef> aList, CharsRef b) {
        if (aList == null || b == null) {
            return false;
        }
        for (CharsRef a : aList) {
            boolean identical = true;
            if (a.length == b.length) {
                for (int i = 0; i < b.length; ++i) {
                    if (Character.toLowerCase(a.charAt(i + a.offset)) == Character.toLowerCase(b.charAt(i + b.offset))) continue;
                    identical = false;
                    break;
                }
            } else {
                identical = false;
            }
            if (!identical) continue;
            return true;
        }
        return false;
    }

    private static char[] toCharArray(CharsRef ref) {
        if (ref.offset == 0 && ref.length == ref.chars.length) {
            return ref.chars;
        }
        return Arrays.copyOfRange(ref.chars, ref.offset, ref.offset + ref.length);
    }

    private static boolean nextSubWord(char[] text, char sep, CharsRef ref) {
        int end;
        int pos;
        for (pos = ref.offset + ref.length; pos < text.length && text[pos] == sep; ++pos) {
        }
        for (end = pos; end < text.length && text[end] != sep; ++end) {
        }
        if (end > pos) {
            ref.chars = text;
            ref.offset = pos;
            ref.length = end - pos;
            return true;
        }
        return false;
    }

    private void removeStemmedSuffix(CompoundItem root, char[] textAsChar) {
        CompoundItem item = root.child;
        root.stemmSize = item == null ? 0 : 99;
        CompoundItem prev = null;
        while (item != null) {
            if (item.type == CompoundItem.Type.Found) {
                this.removeStemmedSuffix(item, textAsChar);
                if (item.stemmSize < root.stemmSize) {
                    root.stemmSize = item.stemmSize;
                }
            } else if (this.isStemmedExtension(textAsChar, item.bgn, item.length, item.bgn + item.length)) {
                if (item.length < root.stemmSize) {
                    root.stemmSize = item.length;
                }
                if (prev != null) {
                    prev.next = item.next;
                } else {
                    root.child = item.next;
                }
                item = item.next;
                continue;
            }
            prev = item;
            item = item.next;
        }
    }

    private boolean isStemmedExtension(char[] textAsChar, int bgn, int length, int fullLength) {
        int newLen;
        int len = length;
        int fullLen = fullLength;
        while ((newLen = this.stemLastCharacter(textAsChar, bgn, len, fullLen)) != len) {
            fullLen -= len - newLen;
            len = newLen;
        }
        return len == 0;
    }

    private int stemLastCharacter(char[] textAsChar, int bgn, int length, int fullLength) {
        if (fullLength > 3 && length > 0) {
            int pos = bgn + length - 1;
            char ch = textAsChar[pos];
            if (pos > 0 && textAsChar[pos - 1] == ch) {
                return length;
            }
            if (!(fullLength <= 4 || pos <= 0 || (ch != 'd' && ch != 'D' || textAsChar[pos - 1] != 'n' && textAsChar[pos - 1] != 'N') && (ch != 'm' && ch != 'M' || textAsChar[pos - 1] != 'e' && textAsChar[pos - 1] != 'E') && (ch != 'r' && ch != 'R' || textAsChar[pos - 1] != 'e' && textAsChar[pos - 1] != 'E'))) {
                return Math.max(length - 2, 0);
            }
            if (ch == 'e' || ch == 'E' ? pos == 0 || textAsChar[pos - 1] != 'i' && textAsChar[pos - 1] != 'I' : (ch == 't' || ch == 'T' ? pos == 0 || textAsChar[pos - 1] != 's' && textAsChar[pos - 1] != 'S' : ch == 'n' || ch == 'N' || ch == 's' || ch == 'S')) {
                return length - 1;
            }
        }
        return length;
    }

    private char[] stemText(char[] textAsChar, int bgn, int length) {
        int len = length;
        char[] stemmed;
        while ((stemmed = this.dictionary.get(textAsChar, bgn, len)) == null || stemmed.length <= 0) {
            int newLen = this.stemLastCharacter(textAsChar, bgn, len, len);
            if (newLen == len) {
                if (len == length) {
                    return null;
                }
                return Arrays.copyOfRange(textAsChar, bgn, bgn + len);
            }
            len = newLen;
        }
        return stemmed;
    }

    private char[] getSynonym(char[] textAsChar, int bgn, int length) {
        char[] stemmed;
        if (this.synDictionary != null && (stemmed = this.synDictionary.get(textAsChar, bgn, length)) != null && stemmed.length > 0) {
            return stemmed;
        }
        return null;
    }

    private void getTokens(List<List<CompoundToken>> tokens, CompoundItem item, boolean onlyExactMatch, boolean onlyFirstMatch, boolean takeNotFound) {
        if (item != null) {
            char[] textAsChar = this.termAtt.buffer();
            this.getTokens(tokens, item, textAsChar, 0, onlyExactMatch, onlyFirstMatch, takeNotFound);
        }
    }

    private void getTokens(List<List<CompoundToken>> tokens, CompoundItem item, char[] textAsChar, int depth, boolean onlyExactMatch, boolean onlyFirstMatch, boolean takeNotFound) {
        CompoundItem child = item.child;
        while (child != null) {
            if (!onlyExactMatch || child.exact) {
                this.addCompoundToken(tokens, child, textAsChar, depth, child.child == null, takeNotFound);
                this.getTokens(tokens, child, textAsChar, depth + 1, onlyExactMatch, onlyFirstMatch, takeNotFound);
                if (onlyFirstMatch) break;
            }
            child = child.next;
        }
    }

    private void getBestTokens(List<List<CompoundToken>> tokens, CompoundItem item, char[] textAsChar, int depth, boolean onlyExactMatch, boolean takeNotFound) {
        int bestStemmed = 100;
        CompoundItem bestChild = null;
        CompoundItem child = item.child;
        while (child != null) {
            if ((!onlyExactMatch || child.exact) && child.stemmSize < bestStemmed) {
                bestStemmed = child.stemmSize;
                bestChild = child;
            }
            child = child.next;
        }
        if (bestChild != null) {
            this.addCompoundToken(tokens, bestChild, textAsChar, depth, bestChild.child == null, takeNotFound);
            this.getBestTokens(tokens, bestChild, textAsChar, depth + 1, onlyExactMatch, takeNotFound);
        }
    }

    private void getTokensInverse(List<List<CompoundToken>> tokens, CompoundItem item) {
        if (item != null) {
            char[] textAsChar = this.termAtt.buffer();
            int depth = this.getTokenTreeDepth(item);
            this.getTokensInverseHelper(tokens, item, textAsChar, depth);
            while (tokens.size() != 0 && tokens.get(0).size() == 0) {
                tokens.remove(0);
            }
        }
    }

    private void getTokensInverseHelper(List<List<CompoundToken>> tokens, CompoundItem item, char[] textAsChar, int depth) {
        CompoundItem child = item.child;
        while (child != null) {
            if (!child.disabled) {
                boolean leaf = child.parent == null || child.parent.type == CompoundItem.Type.Root;
                this.addCompoundToken(tokens, child, textAsChar, depth - 1, leaf, false);
                this.getTokensInverseHelper(tokens, child, textAsChar, depth - 1);
            }
            child = child.next;
        }
    }

    private int getTokenTreeDepth(CompoundItem item) {
        int maxDepth = 0;
        if (item.child != null) {
            CompoundItem child = item.child;
            while (child != null) {
                int depth;
                if (!child.disabled && (depth = this.getTokenTreeDepth(child)) > maxDepth) {
                    maxDepth = depth;
                }
                child = child.next;
            }
        }
        if (item.type != CompoundItem.Type.Root) {
            ++maxDepth;
        }
        return maxDepth;
    }

    private void mergeTokenList(List<List<CompoundToken>> tokens1, List<List<CompoundToken>> tokens2) {
        int idx1;
        int idx2;
        if (tokens2.isEmpty()) {
            return;
        }
        if (tokens1.isEmpty()) {
            tokens1.add(new ArrayList());
            tokens1.addAll(tokens2);
            return;
        }
        int bgn2 = tokens1.size() - tokens2.size();
        if (bgn2 < 1) {
            int minEnd1 = this.getMinEnd(tokens1.get(0));
            int maxBegin2 = this.getMaxBegin(tokens2.get(0));
            bgn2 = maxBegin2 < minEnd1 ? 0 : 1;
        }
        while ((idx2 = (idx1 = tokens1.size() - 1) - bgn2) >= 0) {
            int minEnd1 = this.getMinEnd(tokens1.get(idx1));
            int maxBegin2 = this.getMaxBegin(tokens2.get(idx2));
            if (maxBegin2 < minEnd1) break;
            ++bgn2;
        }
        for (int i = 0; i < tokens2.size(); ++i) {
            int index1 = bgn2 + i;
            if (index1 >= tokens1.size()) {
                tokens1.add(new ArrayList());
            }
            List<CompoundToken> list1 = tokens1.get(index1);
            List<CompoundToken> list2 = tokens2.get(i);
            int oldList1Size = list1.size();
            int[] newIdx = new int[list2.size()];
            int n = 0;
            for (CompoundToken t2 : list2) {
                int idx = this.findInTokenList(t2, list1);
                if (idx == -1) {
                    idx = list1.size();
                    list1.add(t2);
                }
                newIdx[n++] = idx;
            }
            for (int k = oldList1Size; k < list1.size(); ++k) {
                CompoundToken t = list1.get(k);
                if (t.stemmedIndex == -1) continue;
                t.stemmedIndex = newIdx[t.stemmedIndex];
            }
        }
    }

    private int getMaxBegin(List<CompoundToken> tokenList) {
        int maxBegin = 0;
        for (CompoundToken token : tokenList) {
            if (token.bgn <= maxBegin) continue;
            maxBegin = token.bgn;
        }
        return maxBegin;
    }

    private int getMinEnd(List<CompoundToken> tokenList) {
        int minEnd = 10000;
        for (CompoundToken token : tokenList) {
            if (token.bgn + token.length >= minEnd) continue;
            minEnd = token.bgn + token.length;
        }
        return minEnd;
    }

    private void addCompoundToken(List<List<CompoundToken>> tokens, CompoundItem item, char[] textAsChar, int depth, boolean leaf, boolean takeNotFound) {
        this.addCompoundToken(tokens, item.type, textAsChar, item.bgn, item.length, depth, leaf, takeNotFound, !item.exact);
    }

    private void addCompoundToken(List<List<CompoundToken>> tokens, CompoundItem.Type type, char[] textAsChar, int bgn, int length, int depth, boolean leaf, boolean takeNotFound, boolean lowPrio) {
        if (type == CompoundItem.Type.Found) {
            if (depth != 0 || !leaf) {
                char[] stemmed;
                int cIndex = this.addCompoundTokenHelper(tokens, textAsChar, bgn, length, depth, leaf, true, lowPrio);
                if (!(this.isPrefixQuery && leaf || (stemmed = this.stemText(textAsChar, bgn, length)) == null || stemmed.length <= 0)) {
                    CharsRef stemmedWord = new CharsRef();
                    while (CompoundWordTokenFilter.nextSubWord(stemmed, '\t', stemmedWord)) {
                        if (this.stemmedText != null && CompoundWordTokenFilter.containsIgnoreCase(this.stemmedText, stemmedWord)) continue;
                        int stemmedIndex = this.addStemmedCompoundTokenHelper(tokens, stemmedWord, bgn, depth, leaf, lowPrio);
                        if (stemmedWord.offset != 0) continue;
                        this.setStemmedIndex(tokens, depth, cIndex, stemmedIndex);
                    }
                }
            }
        } else if (takeNotFound && type == CompoundItem.Type.NotFound) {
            this.addCompoundTokenHelper(tokens, textAsChar, bgn, length, depth, leaf, false, lowPrio);
        }
    }

    private int findInTokenList(char[] textAsChar, int startPos, int length, int tokenBgn, List<CompoundToken> tokenList) {
        for (int i = 0; i < tokenList.size(); ++i) {
            CompoundToken token = tokenList.get(i);
            if (token.length != length || token.bgn != tokenBgn) continue;
            if (token.stemmed == null) {
                return i;
            }
            if (!CompoundWordTokenFilter.equalsIgnoreCase(textAsChar, startPos, length, token.stemmed, 0, token.stemmed.length)) continue;
            return i;
        }
        return -1;
    }

    private int findInTokenList(CompoundToken token, List<CompoundToken> tokenList) {
        for (int i = 0; i < tokenList.size(); ++i) {
            CompoundToken t = tokenList.get(i);
            if (token.bgn != t.bgn || token.length != t.length || token.leaf != t.leaf || !(token.stemmed == null ? t.stemmed == null : t.stemmed != null && token.stemmed.length == t.stemmed.length)) continue;
            return i;
        }
        return -1;
    }

    private void resizeTokenList(List<List<CompoundToken>> tokens, int depth) {
        while (tokens.size() < depth) {
            tokens.add(new ArrayList());
        }
    }

    private int addCompoundTokenHelper(List<List<CompoundToken>> tokens, char[] textAsChar, int bgn, int length, int depth, boolean leaf, boolean exactToken, boolean lowPrio) {
        int index;
        if (tokens.size() <= depth) {
            this.resizeTokenList(tokens, depth);
            ArrayList<CompoundToken> tlist = new ArrayList<CompoundToken>();
            index = tlist.size();
            tlist.add(new CompoundToken(bgn, length, leaf, exactToken, lowPrio));
            tokens.add(tlist);
        } else {
            List<CompoundToken> tlist = tokens.get(depth);
            index = this.findInTokenList(textAsChar, bgn, length, bgn, tlist);
            if (index == -1) {
                index = tlist.size();
                tlist.add(new CompoundToken(bgn, length, leaf, exactToken, lowPrio));
            } else {
                if (exactToken) {
                    tlist.get((int)index).exactToken = true;
                }
                if (!lowPrio) {
                    tlist.get((int)index).lowPrioToken = false;
                }
            }
        }
        return index;
    }

    private int addStemmedCompoundTokenHelper(List<List<CompoundToken>> tokens, CharsRef stemmedWord, int bgn, int depth, boolean leaf, boolean lowPrio) {
        int index;
        if (tokens.size() <= depth) {
            this.resizeTokenList(tokens, depth);
            ArrayList<CompoundToken> tlist = new ArrayList<CompoundToken>();
            index = tlist.size();
            tlist.add(new CompoundToken(CompoundWordTokenFilter.toCharArray(stemmedWord), bgn, leaf, lowPrio));
            tokens.add(tlist);
        } else {
            List<CompoundToken> tlist = tokens.get(depth);
            index = this.findInTokenList(stemmedWord.chars, stemmedWord.offset, stemmedWord.length, bgn, tlist);
            if (index == -1) {
                index = tlist.size();
                tlist.add(new CompoundToken(CompoundWordTokenFilter.toCharArray(stemmedWord), bgn, leaf, lowPrio));
            } else if (!lowPrio) {
                tlist.get((int)index).lowPrioToken = false;
            }
        }
        return index;
    }

    private void setStemmedIndex(List<List<CompoundToken>> tokens, int depth, int index, int stemmedIndex) {
        List<CompoundToken> tlist = tokens.get(depth);
        tlist.get((int)index).stemmedIndex = stemmedIndex;
    }

    private static boolean searchFromBegin(char[] textAsChar, int textLength, int start, CharArrayMap<char[]> dictionary, CompoundItem parent) {
        boolean found = false;
        for (int i = start + 1; i <= textLength; ++i) {
            int partLength = i - start;
            if (!dictionary.containsKey(textAsChar, start, partLength)) continue;
            found = true;
            CompoundItem child = new CompoundItem(CompoundItem.Type.Found, start, partLength);
            parent.addChild(child);
            if (i >= textLength || CompoundWordTokenFilter.searchFromBegin(textAsChar, textLength, i, dictionary, child)) continue;
            child.addChild(new CompoundItem(CompoundItem.Type.NotFound, i, textLength - i));
        }
        return found;
    }

    private static boolean searchFromEnd(char[] textAsChar, int bgn, int end, CharArrayMap<char[]> dictionary, CompoundItem parent) {
        boolean found = false;
        for (int start = end - 1; start >= bgn; --start) {
            int partLength = end - start;
            if (!dictionary.containsKey(textAsChar, start, partLength)) continue;
            found = true;
            CompoundItem child = new CompoundItem(CompoundItem.Type.Found, start, partLength);
            parent.addChild(child);
            if (start <= 0 || CompoundWordTokenFilter.searchFromEnd(textAsChar, bgn, start, dictionary, child)) continue;
            child.addChild(new CompoundItem(CompoundItem.Type.NotFound, bgn, start - bgn));
        }
        return found;
    }

    private void fixTokenOffset() {
        int offset = 0;
        for (List<CompoundToken> subTokens : this.ctokens) {
            subTokens.sort(new CompoundTokenOffsetSort());
            for (CompoundToken token : subTokens) {
                if (token.bgn > offset) {
                    offset = token.bgn;
                }
                token.offset = offset;
            }
        }
    }

    private void cleanupExactTokens() {
        for (List<CompoundToken> subTokens : this.ctokens) {
            CompoundToken stemmedToken;
            int idx;
            CompoundToken token;
            int i;
            for (i = 0; i < subTokens.size(); ++i) {
                token = subTokens.get(i);
                if (!token.exactToken || token.lowPrioToken || (idx = token.stemmedIndex) == -1) continue;
                stemmedToken = subTokens.get(idx);
                if (token.length <= stemmedToken.maxlen) continue;
                stemmedToken.maxlen = token.length;
                stemmedToken.maxlenHighPrio = true;
            }
            for (i = 0; i < subTokens.size(); ++i) {
                token = subTokens.get(i);
                if (!token.exactToken || !token.lowPrioToken || (idx = token.stemmedIndex) == -1) continue;
                stemmedToken = subTokens.get(idx);
                if (stemmedToken.maxlenHighPrio || token.length <= stemmedToken.maxlen) continue;
                stemmedToken.maxlen = token.length;
            }
            for (i = 0; i < subTokens.size(); ++i) {
                token = subTokens.get(i);
                if (!token.exactToken) continue;
                idx = token.stemmedIndex;
                if (idx != -1) {
                    stemmedToken = subTokens.get(idx);
                    if (token.length == stemmedToken.maxlen) continue;
                    if (idx == i) {
                        token.exactToken = false;
                        continue;
                    }
                    token.dupState = CompoundToken.DuplicateState.DupRemove;
                    continue;
                }
                token.dupState = CompoundToken.DuplicateState.DupExact;
            }
            for (i = subTokens.size() - 1; i >= 0; --i) {
                token = subTokens.get(i);
                if (token.dupState != CompoundToken.DuplicateState.DupRemove) continue;
                subTokens.remove(i);
            }
        }
    }

    private static class CompoundToken {
        int bgn;
        int length;
        int offset = -1;
        final boolean leaf;
        final char[] stemmed;
        int stemmedIndex = -1;
        boolean exactToken;
        int maxlen = -1;
        boolean maxlenHighPrio = false;
        boolean lowPrioToken = false;
        DuplicateState dupState = DuplicateState.DupNone;

        CompoundToken(int bgn, int length, boolean leaf, boolean exactToken, boolean lowPrioToken) {
            this.bgn = bgn;
            this.length = length;
            this.stemmed = null;
            this.leaf = leaf;
            this.exactToken = exactToken;
            this.lowPrioToken = lowPrioToken;
        }

        CompoundToken(char[] stemmed, int bgn, boolean leaf, boolean lowPrioToken) {
            this.bgn = bgn;
            this.length = stemmed.length;
            this.stemmed = stemmed;
            this.leaf = leaf;
            this.exactToken = false;
            this.lowPrioToken = lowPrioToken;
        }

        static enum DuplicateState {
            DupNone,
            DupCopy,
            DupExact,
            DupRemove;

        }
    }

    private static class ComposeItem {
        CompoundItem root = null;
        boolean found = false;
        boolean inverse = false;

        private ComposeItem() {
        }
    }

    public static class CompoundItem {
        Type type;
        int bgn;
        int length;
        CompoundItem child;
        CompoundItem next;
        CompoundItem parent;
        boolean exact;
        boolean disabled;
        int stemmSize;

        CompoundItem(Type type, int bgn, int length) {
            this.type = type;
            this.bgn = bgn;
            this.length = length;
            this.child = null;
            this.next = null;
            this.exact = false;
            this.disabled = false;
            this.stemmSize = 0;
        }

        void addChild(CompoundItem child) {
            if (this.child == null) {
                this.child = child;
            } else {
                child.next = this.child;
                this.child = child;
            }
            child.parent = this;
        }

        boolean evaluateExactMatch() {
            if (this.type == Type.NotFound) {
                this.exact = false;
                return false;
            }
            if (this.type == Type.Found && this.child == null) {
                this.exact = true;
                return true;
            }
            if (this.type == Type.Root || this.type == Type.Found) {
                this.exact = false;
                CompoundItem item = this.child;
                while (item != null) {
                    if (item.evaluateExactMatch()) {
                        this.exact = true;
                    }
                    item = item.next;
                }
                return this.exact;
            }
            return false;
        }

        void disableExactMatch() {
            if (this.child == null) {
                this.disabled = this.exact;
            } else {
                this.disabled = true;
                CompoundItem item = this.child;
                while (item != null) {
                    item.disableExactMatch();
                    if (!item.disabled) {
                        this.disabled = false;
                        break;
                    }
                    item = item.next;
                }
            }
        }

        void removeExactFlag() {
            CompoundItem item = this.child;
            while (item != null) {
                item.removeExactFlag();
                item = item.next;
            }
            this.exact = false;
        }

        void markLongestMatch() {
            int maxlen = this.markLongestMatchStep1();
            this.markLongestMatchStep2(0, maxlen);
        }

        int markLongestMatchStep1() {
            int len = 0;
            if (this.type == Type.Found) {
                len += this.length;
            }
            int maxlen = 0;
            CompoundItem item = this.child;
            while (item != null) {
                int l = item.markLongestMatchStep1();
                if (l > maxlen) {
                    maxlen = l;
                }
                item = item.next;
            }
            return len + maxlen;
        }

        boolean markLongestMatchStep2(int len, int maxlen) {
            if (this.type == Type.Found && (len += this.length) == maxlen) {
                this.exact = true;
            }
            CompoundItem item = this.child;
            while (item != null) {
                if (item.markLongestMatchStep2(len, maxlen)) {
                    this.exact = true;
                }
                item = item.next;
            }
            return this.exact;
        }

        public List<String> toStringList(char[] textAsChar) {
            ArrayList<String> result = new ArrayList<String>();
            String text = null;
            if (this.type == Type.Found) {
                text = new String(textAsChar, this.bgn, this.length);
            }
            if (this.child == null) {
                if (text != null) {
                    result.add(text);
                }
            } else {
                CompoundItem item = this.child;
                while (item != null) {
                    List<String> childList = item.toStringList(textAsChar);
                    for (String childString : childList) {
                        if (text == null) {
                            result.add(childString);
                            continue;
                        }
                        result.add(text + "/" + childString);
                    }
                    item = item.next;
                }
            }
            return result;
        }

        public static enum Type {
            Root,
            Found,
            NotFound;

        }
    }

    private static class CompoundTokenOffsetSort
    implements Comparator<CompoundToken> {
        private CompoundTokenOffsetSort() {
        }

        @Override
        public int compare(CompoundToken a, CompoundToken b) {
            if (a.leaf && !b.leaf) {
                return 1;
            }
            if (!a.leaf && b.leaf) {
                return -1;
            }
            return a.bgn - b.bgn;
        }
    }
}

