/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.analysis;

import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.analysis.filter.ASCIIFoldingFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.AppendModeFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.ClassidFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.CompoundWordTokenFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.DebugPrintTermFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.DuplicateTokenFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.ElisionFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.EnglishPossessiveFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.ExactFlagFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.GermanNormalizationFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.RemoveDuplicateTokenFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.SplitLetterNumberFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.TypeToKeywordFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.TypecodeFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.WildcardFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.WordDelimiterGraphFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.ZeroFilter;
import de.cadenas.catalogsearch.lucene.analysis.filter.icu.ICUTokenizer;
import de.cadenas.util.PFile;
import de.cadenas.util.PLogger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArrayMap;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.es.SpanishLightStemFilter;
import org.apache.lucene.analysis.fr.FrenchLightStemFilter;
import org.apache.lucene.analysis.it.ItalianLightStemFilter;

public class FieldAwareAnalyzer
extends Analyzer {
    private static PLogger logger = new PLogger(FieldAwareAnalyzer.class.getSimpleName());
    private static Map<String, CharArrayMap<char[]>> stemmedDict = new HashMap<String, CharArrayMap<char[]>>();
    private static Map<String, CharArrayMap<char[]>> synDict = new HashMap<String, CharArrayMap<char[]>>();
    private static final Object globalLock = new Object();
    private final boolean _isIndexer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharArrayMap<char[]> getStemmedDict(String language) {
        Object object = globalLock;
        synchronized (object) {
            CharArrayMap<char[]> dict = stemmedDict.get(language);
            if (dict == null) {
                dict = FieldAwareAnalyzer.readDictionary("stemmer", language);
                stemmedDict.put(language, dict);
            }
            return dict;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharArrayMap<char[]> getSynonymDict(String language) {
        Object object = globalLock;
        synchronized (object) {
            CharArrayMap<char[]> dict = synDict.get(language);
            if (dict == null) {
                dict = FieldAwareAnalyzer.readDictionary("synonyms", language);
                synDict.put(language, dict);
            }
            return dict;
        }
    }

    private static CharArrayMap<char[]> readDictionary(String dictType, String language) {
        CharArrayMap<char[]> dict;
        block15: {
            dict = null;
            try {
                ByteArrayInputStream is;
                char[] emptyList = new char[]{};
                dict = new CharArrayMap<char[]>(1024, true);
                byte[] fileContents = PFile.readFileContents("$CADENAS_SETUP/search/" + dictType + "/" + language + ".dict");
                if (fileContents == null) break block15;
                try (ByteArrayInputStream byteArrayInputStream = is = new ByteArrayInputStream(fileContents);
                     BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));){
                    String s = null;
                    while ((s = br.readLine()) != null) {
                        int pos = (s = s.trim()).indexOf(9);
                        if (pos == -1) {
                            dict.put(s, emptyList);
                            continue;
                        }
                        char[] word = new char[pos];
                        char[] stemmed = new char[s.length() - pos - 1];
                        s.getChars(0, pos, word, 0);
                        s.getChars(pos + 1, s.length(), stemmed, 0);
                        dict.put(word, stemmed);
                    }
                }
            }
            catch (IOException ex) {
                logger.error("can not read dictionary for language " + language);
            }
        }
        return dict;
    }

    public FieldAwareAnalyzer(boolean isIndexer) {
        super(PER_FIELD_REUSE_STRATEGY);
        this._isIndexer = isIndexer;
    }

    @Override
    public int getPositionIncrementGap(String fieldName) {
        return 1;
    }

    @Override
    public Analyzer.TokenStreamComponents createComponents(String fullFieldName) {
        boolean isIcuTokenized;
        Tokenizer src;
        String fieldName = fullFieldName;
        boolean isPrefixQuery = false;
        boolean isExactQuery = false;
        boolean isWildcardQuery = false;
        if (fieldName.endsWith("_ex")) {
            fieldName = fieldName.substring(0, fullFieldName.length() - "_ex".length());
            isExactQuery = true;
        }
        if (fieldName.endsWith("_pre")) {
            fieldName = fieldName.substring(0, fullFieldName.length() - "_pre".length());
            isPrefixQuery = true;
        } else if (fieldName.endsWith("_wld")) {
            fieldName = fieldName.substring(0, fullFieldName.length() - "_wld".length());
            isWildcardQuery = true;
        }
        if (FieldDefinitions.isUntokenizedField(fieldName) || FieldDefinitions.isNumberField(fieldName)) {
            return new Analyzer.TokenStreamComponents(new KeywordTokenizer());
        }
        if (fieldName.equals("ordernumber") || fieldName.equals("typecode")) {
            KeywordTokenizer src2 = new KeywordTokenizer();
            TokenStream stream = this.createOrdernoTypecodeTokenizer(src2, isExactQuery);
            return new Analyzer.TokenStreamComponents(src2, stream);
        }
        if (fieldName.equals("classid")) {
            KeywordTokenizer src3 = new KeywordTokenizer();
            ClassidFilter stream = new ClassidFilter(new LowerCaseFilter(src3), this._isIndexer);
            return new Analyzer.TokenStreamComponents(src3, (TokenStream)stream);
        }
        if (fieldName.endsWith("_exact") || fieldName.equals("exactdata")) {
            WhitespaceTokenizer src4 = new WhitespaceTokenizer();
            TokenFilter stream = new LowerCaseFilter(src4);
            stream = new ExactFlagFilter(stream);
            return new Analyzer.TokenStreamComponents(src4, (TokenStream)stream);
        }
        if (FieldDefinitions.isICUTokenized(fieldName)) {
            src = new ICUTokenizer(isWildcardQuery);
            isIcuTokenized = true;
        } else {
            src = new WhitespaceTokenizer();
            isIcuTokenized = false;
        }
        TokenStream stream = src;
        if (isExactQuery) {
            boolean keepEnglishPossessive = false;
            String langOfField = FieldDefinitions.getLanguageOfField(fieldName);
            if (langOfField != null) {
                keepEnglishPossessive = langOfField.equals("english");
            }
            stream = this.createExactSearchTokenizer(src, isWildcardQuery, isIcuTokenized, keepEnglishPossessive);
        } else {
            String language;
            stream = FieldDefinitions.isTranslatedField(fieldName) ? ((language = FieldDefinitions.getLanguageOfField(fieldName)) == null ? this.createDefaultTokenizer(stream, isWildcardQuery) : (language.equals("german") ? this.createGermanTokenizer(stream, isPrefixQuery, isWildcardQuery) : (language.equals("english") ? this.createEnglishTokenizer(stream, isWildcardQuery) : (language.equals("french") ? this.createFrenchTokenizer(stream) : (language.equals("italian") ? this.createItalianTokenizer(stream) : (language.equals("spanish") ? this.createSpanishTokenizer(stream) : (language.equals("korean") || language.startsWith("chinese") || language.equals("japanese") ? this.createCJKTokenizer(stream) : this.createDefaultTokenizer(stream, isWildcardQuery)))))))) : this.createDefaultTokenizer(stream, isWildcardQuery);
        }
        if (logger.traceEnabled()) {
            stream = new DebugPrintTermFilter(fullFieldName, stream);
        }
        if (this._isIndexer) {
            stream = new AppendModeFilter(stream);
        }
        return new Analyzer.TokenStreamComponents(src, stream);
    }

    private TokenStream createExactSearchTokenizer(TokenStream in, boolean isWildcardQuery, boolean isIcuTokenized, boolean keepEnglishPossessive) {
        TokenStream stream = isIcuTokenized ? new SplitLetterNumberFilter(in) : this.addWordDelimeterFilter(in, keepEnglishPossessive, isWildcardQuery);
        if (isWildcardQuery) {
            stream = new WildcardFilter(stream);
        }
        stream = new LowerCaseFilter(stream);
        return new RemoveDuplicateTokenFilter(stream);
    }

    private TokenStream createOrdernoTypecodeTokenizer(TokenStream in, boolean isExactQuery) {
        if (isExactQuery) {
            return new LowerCaseFilter(in);
        }
        TokenFilter stream = new TypecodeFilter(in);
        stream = new LowerCaseFilter(stream);
        return new RemoveDuplicateTokenFilter(stream);
    }

    private TokenStream createLanguageTokenizer(TokenStream in, boolean keepPossessive, boolean isWildcardQuery, LanguageTokenizer languageTokenizer) {
        TokenStream stream = this.addWordDelimeterFilter(in, keepPossessive, isWildcardQuery);
        if (isWildcardQuery) {
            stream = new WildcardFilter(stream);
        }
        if (languageTokenizer != null) {
            stream = languageTokenizer.createTokenStream(stream);
        }
        stream = this.createLanguageCommonTokenizer(stream);
        return stream;
    }

    private TokenStream createLanguageCommonTokenizer(TokenStream in) {
        TokenFilter stream = new ASCIIFoldingFilter(in);
        stream = new ZeroFilter(stream);
        stream = new LowerCaseFilter(stream);
        stream = new RemoveDuplicateTokenFilter(stream);
        return stream;
    }

    private TokenStream createGermanTokenizer(TokenStream in, boolean isPrefixQuery, boolean isWildCardQuery) {
        return this.createLanguageTokenizer(in, false, isWildCardQuery, input -> {
            TokenStream stream = input;
            CharArrayMap<char[]> stemmedDict = FieldAwareAnalyzer.getStemmedDict("german");
            CharArrayMap<char[]> synDict = FieldAwareAnalyzer.getSynonymDict("german");
            if (stemmedDict != null) {
                stream = new CompoundWordTokenFilter(input, stemmedDict, synDict, this._isIndexer, isPrefixQuery);
            }
            return new GermanNormalizationFilter(stream);
        });
    }

    private TokenStream createEnglishTokenizer(TokenStream in, boolean isWildcardQuery) {
        return this.createLanguageTokenizer(in, true, isWildcardQuery, input -> {
            TokenFilter stream = new DuplicateTokenFilter(input);
            stream = new EnglishPossessiveFilter(stream);
            stream = new PorterStemFilter(stream);
            return stream;
        });
    }

    private TokenStream createFrenchTokenizer(TokenStream in) {
        TokenStream stream = new SplitLetterNumberFilter(in);
        stream = new DuplicateTokenFilter(stream);
        stream = new ElisionFilter(stream, FieldDefinitions.frenchArticles);
        stream = new FrenchLightStemFilter(stream);
        stream = this.createLanguageCommonTokenizer(stream);
        return stream;
    }

    private TokenStream createItalianTokenizer(TokenStream in) {
        TokenStream stream = new SplitLetterNumberFilter(in);
        stream = new DuplicateTokenFilter(stream);
        stream = new ItalianLightStemFilter(stream);
        stream = this.createLanguageCommonTokenizer(stream);
        return stream;
    }

    private TokenStream createSpanishTokenizer(TokenStream in) {
        TokenStream stream = new SplitLetterNumberFilter(in);
        stream = new DuplicateTokenFilter(stream);
        stream = new SpanishLightStemFilter(stream);
        stream = this.createLanguageCommonTokenizer(stream);
        return stream;
    }

    private TokenStream createDefaultTokenizer(TokenStream in, boolean isWildcardQuery) {
        return this.createLanguageTokenizer(in, false, isWildcardQuery, DuplicateTokenFilter::new);
    }

    private TokenStream createCJKTokenizer(TokenStream in) {
        TokenFilter stream = new SplitLetterNumberFilter(in);
        stream = new TypeToKeywordFilter(stream);
        stream = new DuplicateTokenFilter(stream);
        stream = new ZeroFilter(stream);
        stream = new LowerCaseFilter(stream);
        stream = new RemoveDuplicateTokenFilter(stream);
        return stream;
    }

    private TokenStream addWordDelimeterFilter(TokenStream inStream, boolean keepEnglishPossesive, boolean keepWildcards) {
        return new WordDelimiterGraphFilter(inStream, keepEnglishPossesive, keepWildcards);
    }

    public static interface LanguageTokenizer {
        public TokenStream createTokenStream(TokenStream var1);
    }
}

