/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.api;

import de.cadenas.catalogsearch.api.impl.FacetsRequestImpl;
import de.cadenas.catalogsearch.lucene.search.SearchResultFilter;
import de.cadenas.util.PGenericPair;
import java.util.List;
import java.util.Map;

public interface ISearchRequest {
    public String getQuery();

    public int getOffset();

    public int getLineOffset();

    public int getLimit();

    public int getVariableFacetCount();

    public boolean isFacetedSearch();

    public int facetTypes();

    public List<String> facetFilter();

    public boolean keepSearch();

    public int getSearchId();

    public boolean isTaxoSearch();

    public boolean restoreVarsets();

    public boolean searchDocuments();

    public String docHlStart();

    public String docHlEnd();

    public boolean binaryResponse();

    public boolean explainResults();

    public boolean isTreeView();

    public boolean countProjects();

    public boolean evaluateCommonDir();

    public List<String> getLanguageList();

    public List<PathFilter> getPathFilters();

    public SearchResultFilter getByProjectFilter();

    public Map<String, List<FacetsRequestImpl.PartId>> getPartFilter();

    public Map<String, List<String>> getExcludedProjectsFilter();

    public List<TermFilter> getTermFilters();

    public List<RangeFilter> getRangeFilters();

    public String getErpGroupName();

    public boolean isErpPreferredLine();

    public String getErpFilterQuery();

    public List<LicenseRange> getLicenseRange();

    public boolean getForceFacetCreation();

    public int getThreadCount();

    public String getChildFolderFilter();

    public static class LicenseRange {
        private final String catalog;
        private int lower = -1;
        private int upper = -1;

        public LicenseRange(String catalog, int lower, int upper) {
            this.catalog = catalog;
            this.lower = lower;
            this.upper = upper;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public int getLower() {
            return this.lower;
        }

        public int getUpper() {
            return this.upper;
        }
    }

    public static class PathFilter {
        private final List<String> catalogList;
        private final List<String> treeList;
        private final List<PGenericPair<String, String>> pathList;
        private final List<String> excludeList;

        public PathFilter(List<String> catalogList, List<String> treeList, List<PGenericPair<String, String>> pathList, List<String> excludeList) {
            this.catalogList = catalogList;
            this.treeList = treeList;
            this.pathList = pathList;
            this.excludeList = excludeList;
        }

        public List<String> getCatalogList() {
            return this.catalogList;
        }

        public List<String> getTreeList() {
            return this.treeList;
        }

        public List<PGenericPair<String, String>> getPathList() {
            return this.pathList;
        }

        public List<String> getExcludeList() {
            return this.excludeList;
        }
    }

    public static class RangeFilter {
        private final String dim;
        private final double low;
        private final double high;
        private final boolean isErpFilter;

        public RangeFilter(String dim, double low, double high, boolean erp) {
            this.dim = dim;
            this.low = low;
            this.high = high;
            this.isErpFilter = erp;
        }

        public String getDim() {
            return this.dim;
        }

        public double getLow() {
            return this.low;
        }

        public double getHigh() {
            return this.high;
        }

        public boolean isErpFilter() {
            return this.isErpFilter;
        }
    }

    public static class TermFilter {
        private final String dim;
        private final String value;
        private final boolean isErpFilter;
        private final boolean andConjunction;

        public TermFilter(String dim, String value, boolean erp, boolean andConjunction) {
            this.dim = dim;
            this.value = value;
            this.isErpFilter = erp;
            this.andConjunction = andConjunction;
        }

        public String getDim() {
            if (this.dim.startsWith("v:")) {
                return this.dim.substring(2);
            }
            return this.dim;
        }

        public String getFullDim() {
            return this.dim;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isErpFilter() {
            return this.isErpFilter;
        }

        public boolean useAndConjunction() {
            return this.andConjunction;
        }
    }
}

