/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.api;

import de.cadenas.catalogsearch.api.IDocIdIndex;
import de.cadenas.catalogsearch.api.IIndexLoadRequest;
import de.cadenas.catalogsearch.api.ISearchRequest;
import de.cadenas.catalogsearch.api.ITreePathIndex;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.IndexSearcher;

public interface IIndexManager {
    public void shutdown() throws Exception;

    public void loadIndex(List<IIndexLoadRequest> var1) throws Exception;

    public IndexReader getIndexReader(FieldDefinitions.IndexType var1, String var2);

    public IIndexReaderData findReaderData(IndexReader var1);

    public Collection<IndexReader> getReadersByType(FieldDefinitions.IndexType var1);

    public Collection<String> getAllLoadedCatalogsByType(FieldDefinitions.IndexType var1);

    public List<String> mapToContainingCatalogs(List<String> var1);

    public IndexSearcherContainerLocked createIndexSearcher(ISearchRequest var1, FieldDefinitions.IndexType var2, ExecutorService var3) throws IOException;

    public IndexSearcherContainerLocked createIndexSearcher(List<String> var1, FieldDefinitions.IndexType var2, ExecutorService var3) throws IOException;

    public SortedSetDocValuesReaderState createReaderState(IndexReader var1, FieldDefinitions.IndexType var2, FieldDefinitions.FacetType var3) throws IOException;

    public void clearReaderStateCache();

    public IndexSearcher createSpellSearcher(List<String> var1, ExecutorService var2) throws IOException;

    public IndexSearcher createRelatedWordsSearcher(List<String> var1, ExecutorService var2) throws IOException;

    public static interface IIndexIDRangeProvider {
        public IRange getRange(int var1);

        public void freeRange(int var1, int var2);

        public static interface IRange {
            public int base();

            public int size();
        }
    }

    public static interface IIndexReaderContainer {
        public String getCatalogName();

        public String getIndexPath();

        public IndexReader getIndexReader();

        public IndexReader getSpellReader();

        public IndexReader getRelatedReader();
    }

    public static interface IIndexReaderData {
        public String getCatalogName();

        public Set<String> getUsedCatalogNames();

        public String getIndexPath();

        public IndexReader getIndexReader();

        public IndexReader getSpellReader();

        public IndexReader getRelatedReader();

        public IDocIdIndex getDocIdIndex();

        public ITreePathIndex getTreePathIndex();

        public int getBaseDocId();

        public int getLeafId(LeafReader var1);

        public void cacheFacets();

        public void cacheOrds();

        public int[] getGlobalFacetMapping();

        public String getDimName(int var1, int var2);

        public float getBoost();
    }

    public static class IndexSearcherContainerLocked
    implements Closeable {
        private final IndexSearcherContainer container;
        private IndexSearcher indexSearcher;
        private boolean closed = false;

        public IndexSearcherContainerLocked(IndexSearcherContainer c) {
            this.container = c;
            this.container.incRef();
        }

        public void setIndexSearcher(IndexSearcher searcher) {
            this.indexSearcher = searcher;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.container.decRef();
                this.closed = true;
            }
        }

        public IndexSearcherContainer getContainer() {
            return this.container;
        }

        public IndexSearcher getIndexSearcher() {
            return this.indexSearcher;
        }
    }

    public static abstract class IndexSearcherContainer {
        public IndexReader multiReader = null;
        public boolean hasCatalogBoosts = false;
        public FieldDefinitions.IndexType indexType;
        private final AtomicInteger refCount = new AtomicInteger(1);

        private void doClose() {
            try {
                if (this.multiReader != null) {
                    this.multiReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void close() {
            this.decRef();
        }

        public void incRef() {
            this.refCount.incrementAndGet();
        }

        public void decRef() {
            if (this.refCount.decrementAndGet() == 0) {
                this.doClose();
            }
        }

        public IndexReader getIndexReader() {
            return this.multiReader;
        }

        public abstract BoostRange[] getCatalogBoosts();
    }

    public static class BoostRange
    implements Comparable<BoostRange> {
        public int low;
        public int up;
        public float boost;

        @Override
        public int compareTo(BoostRange other) {
            return this.low - other.low;
        }
    }
}

