/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch;

import de.cadenas.util.PDataStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HighlightingRequest {
    public String searchQuery;
    public String requesterName;
    public List<Fragment> fragments = null;
    public String preTag = "";
    public String postTag = "";
    public List<String> languageList = null;
    private static final Map<String, String[]> typeMap = new HashMap<String, String[]>();
    private static final Map<String, String[]> langFields;

    public static HighlightingRequest fromBinary(byte[] data) {
        int countFragments;
        HighlightingRequest request = new HighlightingRequest();
        PDataStream stream = new PDataStream(data, 0, data.length);
        request.searchQuery = Objects.requireNonNullElse(stream.readString(), "");
        request.requesterName = Objects.requireNonNullElse(stream.readString(), "");
        request.preTag = Objects.requireNonNullElse(stream.readString(), "");
        request.postTag = Objects.requireNonNullElse(stream.readString(), "");
        request.languageList = new ArrayList<String>();
        List<String> languages = stream.readStringList();
        if (languages != null) {
            for (String lang : languages) {
                if (lang == null || lang.isEmpty() || request.languageList.contains(lang)) continue;
                request.languageList.add(lang);
            }
        }
        if (request.preTag.isEmpty()) {
            request.preTag = "<b>";
        }
        if (request.postTag.isEmpty()) {
            request.postTag = "</b>";
        }
        if ((countFragments = stream.readInt()) > 0) {
            HashSet<String> additionalLanguages = new HashSet<String>();
            request.fragments = new ArrayList<Fragment>();
            for (int i = 0; i < countFragments; ++i) {
                String[] langNames;
                String[] fieldNames;
                String fieldType = stream.readString();
                if (fieldType == null || fieldType.isEmpty()) {
                    fieldType = "text";
                }
                String value = Objects.requireNonNullElse(stream.readString(), "");
                String variableName = Objects.requireNonNullElse(stream.readString(), "").toLowerCase();
                String language = Objects.requireNonNullElse(stream.readString(), "");
                double convertedValue = stream.readBool() ? stream.readDouble() : Double.NaN;
                int pq = stream.readInt();
                if (!language.isEmpty()) {
                    additionalLanguages.add(language);
                }
                String[] fixNames = typeMap.getOrDefault(fieldType, null);
                if (!variableName.isEmpty() && fixNames.length > 1) {
                    ArrayList<String> fixList = new ArrayList<String>(Arrays.asList(fixNames));
                    fixList.set(fixList.size() - 1, fixList.get(fixList.size() - 1) + variableName);
                    for (String lang : request.languageList) {
                        fixList.add("col_text_" + variableName + "_" + lang + "_lang");
                    }
                    if (!language.isEmpty() && !request.languageList.contains(language)) {
                        fixList.add("col_text_" + variableName + "_" + language + "_lang");
                    }
                    fixNames = fixList.toArray(new String[0]);
                }
                if ((fieldNames = HighlightingRequest.mergeFields(fixNames, langNames = (String[])langFields.getOrDefault(fieldType, null), request.languageList, language)) == null) continue;
                Fragment frag = new Fragment();
                frag.fieldNames = fieldNames;
                frag.value = value;
                frag.convertedValue = convertedValue;
                frag.physicalQuantity = pq;
                request.fragments.add(frag);
            }
            request.languageList.addAll(additionalLanguages);
        }
        return request;
    }

    public static String[] mergeFields(String[] fixNames, String[] langNames, List<String> languageList, String additionalLanguage) {
        boolean addLang;
        if (langNames == null) {
            return fixNames;
        }
        int count = 0;
        if (fixNames != null) {
            count = fixNames.length;
        }
        count += langNames.length * languageList.size();
        boolean bl = addLang = !additionalLanguage.isEmpty() && !languageList.contains(additionalLanguage);
        if (addLang) {
            count += langNames.length;
        }
        String[] result = new String[count];
        int pos = 0;
        if (fixNames != null) {
            System.arraycopy(fixNames, 0, result, 0, fixNames.length);
            pos = fixNames.length;
        }
        for (String lname : langNames) {
            for (String language : languageList) {
                result[pos++] = lname.replace("%", language);
            }
            if (!addLang) continue;
            result[pos++] = lname.replace("%", additionalLanguage);
        }
        return result;
    }

    static {
        typeMap.put("catalog", new String[]{"catalog"});
        typeMap.put("nn", new String[]{"col_text_tags", "nn_exact"});
        typeMap.put("nt", new String[]{"col_text_tags", "nt_exact"});
        typeMap.put("nb", new String[]{"col_text_tags", "nb_exact"});
        typeMap.put("text", new String[]{"numbervalues", "textvalues_exact", "col_text_", "col_number_"});
        typeMap.put("numeric", new String[]{"numbervalues", "textvalues_exact", "col_number_"});
        typeMap.put("classid", new String[]{"classid"});
        typeMap.put("topo", new String[]{"topoanyvalue"});
        String langPostfix = "_%_lang";
        langFields = new HashMap<String, String[]>();
        langFields.put("nn", new String[]{"nn" + langPostfix});
        langFields.put("nt", new String[]{"nt" + langPostfix});
        langFields.put("nb", new String[]{"nb" + langPostfix});
        langFields.put("text", new String[]{"textvalues" + langPostfix});
    }

    public static class Fragment {
        public String[] fieldNames;
        public String value;
        public double convertedValue = Double.NaN;
        public int physicalQuantity = 0;

        public String toString() {
            return this.value;
        }
    }
}

