/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas;

import de.cadenas.IndexGenerator;
import de.cadenas.catalogsearch.CADENAS;
import de.cadenas.catalogsearch.HighlightingRequest;
import de.cadenas.catalogsearch.api.IFacetsResult;
import de.cadenas.catalogsearch.api.IIndexLoadRequest;
import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.api.ISearchRequest;
import de.cadenas.catalogsearch.api.ISearchResult;
import de.cadenas.catalogsearch.api.ISearchServiceApi;
import de.cadenas.catalogsearch.api.ServiceFactory;
import de.cadenas.catalogsearch.api.impl.FacetsRequestImpl;
import de.cadenas.catalogsearch.api.impl.SearchRequestImpl;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.index.ExplanationData;
import de.cadenas.catalogsearch.lucene.index.FieldInfoData;
import de.cadenas.catalogsearch.lucene.index.MergeIndexData;
import de.cadenas.catalogsearch.lucene.index.OpenIndexRequest;
import de.cadenas.catalogsearch.lucene.index.ProjectInfoData;
import de.cadenas.catalogsearch.lucene.index.RemoveDataRequest;
import de.cadenas.catalogsearch.lucene.index.TextSearchIndexerData.ProjectData;
import de.cadenas.catalogsearch.lucene.related.OpenRelatedIndexRequest;
import de.cadenas.catalogsearch.lucene.related.RelatedDataRequest;
import de.cadenas.catalogsearch.lucene.related.RelatedIndexer;
import de.cadenas.catalogsearch.lucene.related.RelatedWord;
import de.cadenas.catalogsearch.lucene.related.RelatedWordsRequest;
import de.cadenas.catalogsearch.lucene.spell.OpenSpellIndexRequest;
import de.cadenas.catalogsearch.lucene.spell.SpellCheckRequest;
import de.cadenas.catalogsearch.lucene.spell.SpellDataRequest;
import de.cadenas.catalogsearch.lucene.spell.SpellIndexer;
import de.cadenas.catalogsearch.lucene.util.BinarySerialization;
import de.cadenas.catalogsearch.lucene.util.IndexAnalyzer;
import de.cadenas.catalogsearch.lucene.util.JsonSerialization;
import de.cadenas.util.PDataStream;
import de.cadenas.util.PGenericPair;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.json.JSONArray;
import org.json.JSONObject;

public class InProcController {
    private final AtomicInteger _indexerId = new AtomicInteger(0);
    private final Map<Integer, IndexGenerator> _activeIndexGenerators = new HashMap<Integer, IndexGenerator>();
    private final Map<Integer, SpellIndexer> _activeSpellGenerators = new TreeMap<Integer, SpellIndexer>();
    private final Map<Integer, RelatedIndexer> _activeRelatedGenerators = new TreeMap<Integer, RelatedIndexer>();

    InProcController(String cadenasData, String cadenasIndex) {
        CADENAS.initFromCadenasData(cadenasData, cadenasIndex);
        IndexSearcher.setMaxClauseCount(0x40000000);
    }

    public int loadSearchIndex(String requestAsJson) throws Exception {
        JSONObject jRequest = new JSONObject(requestAsJson);
        List<IIndexLoadRequest> loadRequest = JsonSerialization.indexLoadRequestFromJson(jRequest);
        ServiceFactory.getIndexManager().loadIndex(loadRequest);
        return 1;
    }

    public byte[] executeSearchQuery(String requestAsJson) throws Exception {
        long start = System.nanoTime();
        JSONObject jRequest = new JSONObject(requestAsJson);
        ISearchRequest req = JsonSerialization.fromJson(jRequest);
        IIndexManager indexManager = ServiceFactory.getIndexManager();
        ISearchResult result = ServiceFactory.getSearchService().executeSearch(req, indexManager);
        if (result != null) {
            if (req.binaryResponse()) {
                return BinarySerialization.serialize(result, start);
            }
            String json = JsonSerialization.toJson(result, start).toString();
            return json.getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }

    public byte[] executeFacetsQuery(byte[] request) throws Exception {
        FacetsRequestImpl facetsRequest = FacetsRequestImpl.fromBinary(request);
        IIndexManager indexManager = ServiceFactory.getIndexManager();
        IFacetsResult result = ServiceFactory.getSearchService().retrieveFacets(facetsRequest, indexManager);
        if (result != null) {
            return BinarySerialization.serialize(result);
        }
        return null;
    }

    public void releaseSearch(int searchId) {
        try {
            ServiceFactory.getSearchService().releaseSearch(searchId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] estimateResultCount(String requestAsJson) throws Exception {
        JSONObject jRequest = new JSONObject(requestAsJson);
        ISearchRequest req = JsonSerialization.fromJson(jRequest);
        IIndexManager indexManager = ServiceFactory.getIndexManager();
        ISearchServiceApi.CountingResult estimationResult = ServiceFactory.getSearchService().estimateResultCount(req, indexManager);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PDataStream stream = new PDataStream(outStream);
        if (estimationResult == null) {
            stream.write(0);
            stream.write(0);
        } else {
            stream.write(estimationResult.totalHitCount());
            stream.write(estimationResult.usedCatalogs().size());
            for (String catalog : estimationResult.usedCatalogs()) {
                stream.write(catalog);
            }
        }
        return outStream.toByteArray();
    }

    public String executeHighlightRequest(byte[] binRequest) throws Exception {
        HighlightingRequest request = HighlightingRequest.fromBinary(binRequest);
        if (request.fragments == null || request.fragments.isEmpty()) {
            return "";
        }
        IIndexManager indexManager = ServiceFactory.getIndexManager();
        PGenericPair<List<String>, Boolean> response = ServiceFactory.getSearchService().executeHighlighting(request, indexManager);
        if (response != null && ((List)response.first).size() == request.fragments.size()) {
            return JsonSerialization.highlightingResponseToJson(response).toString();
        }
        return "";
    }

    public String executeSpellCheckRequest(String requestAsJson) throws Exception {
        JSONObject jRequest = new JSONObject(requestAsJson);
        SpellCheckRequest request = SpellCheckRequest.fromJson(jRequest);
        IIndexManager indexManager = ServiceFactory.getIndexManager();
        String[] result = ServiceFactory.getSearchService().executeSpellCheck(request, indexManager);
        if (result != null) {
            return JsonSerialization.stringArrayToJson(result).toString();
        }
        return "";
    }

    public String executeRelatedWordsRequest(String requestAsJson) throws Exception {
        JSONObject jRequest = new JSONObject(requestAsJson);
        RelatedWordsRequest request = RelatedWordsRequest.fromJson(jRequest);
        IIndexManager indexManager = ServiceFactory.getIndexManager();
        List<RelatedWord> result = ServiceFactory.getSearchService().executeRelatedWordSearch(request, indexManager);
        if (result != null) {
            return RelatedWord.serializeList(result).toString();
        }
        return "";
    }

    public byte[] getFieldInfos(String path, String type, int[] documentIds) {
        FieldDefinitions.IndexType indexType = FieldDefinitions.IndexType.fromString(type);
        if (indexType == null) {
            indexType = FieldDefinitions.IndexType.LinkDb;
        }
        try {
            IIndexManager indexManager = ServiceFactory.getIndexManager();
            IndexReader reader = indexManager.getIndexReader(indexType, path);
            if (reader != null) {
                IndexAnalyzer analyzer = new IndexAnalyzer(reader);
                if (documentIds == null || documentIds.length == 0) {
                    return null;
                }
                Arrays.sort(documentIds);
                FieldInfoData infoData = analyzer.retrieveFieldInfos(documentIds);
                if (infoData != null) {
                    return infoData.toBinary();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getProjectInfos(String path, String type) {
        FieldDefinitions.IndexType indexType = FieldDefinitions.IndexType.fromString(type);
        if (indexType == null) {
            indexType = FieldDefinitions.IndexType.LinkDb;
        }
        try {
            IIndexManager indexManager = ServiceFactory.getIndexManager();
            IndexReader reader = indexManager.getIndexReader(indexType, path);
            if (reader != null) {
                IndexAnalyzer analyzer = new IndexAnalyzer(reader);
                List<ProjectInfoData> projectInfos = analyzer.retrieveProjectInfos();
                return JsonSerialization.toJson(projectInfos).toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public byte[] explainSearchResults(String requestAsJson) {
        JSONObject jRequest = new JSONObject(requestAsJson);
        ISearchRequest req = JsonSerialization.fromJson(jRequest);
        try {
            IIndexManager indexManager = ServiceFactory.getIndexManager();
            ExplanationData explanation = ServiceFactory.getSearchService().explainSearchResults(req, indexManager);
            return explanation.toBinary();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int checkHealth(String searchWord) throws Exception {
        IIndexManager indexManager = ServiceFactory.getIndexManager();
        Collection<String> catalogList = indexManager.getAllLoadedCatalogsByType(FieldDefinitions.IndexType.Fulltext);
        if (!catalogList.isEmpty()) {
            SearchRequestImpl req = new SearchRequestImpl();
            req.pathFilters.add(new ISearchRequest.PathFilter(new ArrayList<String>(catalogList), null, null, null));
            req.query = searchWord;
            req.searchDocuments = false;
            req.languageList.add("english");
            ISearchResult iSearchResult = ServiceFactory.getSearchService().executeSearch(req, indexManager);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int openIndexGenerator(String requestAsJson) throws Exception {
        JSONObject jRequest = new JSONObject(requestAsJson);
        OpenIndexRequest request = OpenIndexRequest.fromJson(jRequest);
        int generatorId = this._indexerId.incrementAndGet();
        IndexGenerator generator = null;
        IndexWriterConfig.OpenMode openMode = request.openMode.orElse(IndexWriterConfig.OpenMode.CREATE);
        generator = new IndexGenerator(request, openMode);
        Map<Integer, IndexGenerator> map = this._activeIndexGenerators;
        synchronized (map) {
            this._activeIndexGenerators.put(generatorId, generator);
        }
        return generatorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeIndexGenerator(int generatorId) {
        IndexGenerator generator = null;
        Map<Integer, IndexGenerator> map = this._activeIndexGenerators;
        synchronized (map) {
            generator = this._activeIndexGenerators.get(generatorId);
            this._activeIndexGenerators.remove(generatorId);
        }
        if (generator != null) {
            generator.close();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addProjectData(int generatorId, byte[] data) throws Exception {
        IndexGenerator generator = null;
        Map<Integer, IndexGenerator> map = this._activeIndexGenerators;
        synchronized (map) {
            generator = this._activeIndexGenerators.get(generatorId);
        }
        if (generator != null) {
            ByteBuffer buffer = ByteBuffer.wrap(data);
            ProjectData prjData = ProjectData.getRootAsProjectData(buffer);
            generator.addProject(prjData);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeData(int generatorId, String data) throws Exception {
        IndexGenerator generator = null;
        Map<Integer, IndexGenerator> map = this._activeIndexGenerators;
        synchronized (map) {
            generator = this._activeIndexGenerators.get(generatorId);
        }
        if (generator != null) {
            JSONArray arr = new JSONArray(data);
            RemoveDataRequest removeRequest = JsonSerialization.removeDataRequestFromJson(arr);
            return generator.removeData(removeRequest);
        }
        return -1;
    }

    public boolean mergeIndex(String data) throws Exception {
        JSONObject json = new JSONObject(data);
        MergeIndexData mergeRequest = JsonSerialization.mergeRequestFromJson(json);
        if (mergeRequest.indexPath != null && !mergeRequest.indexPath.isEmpty()) {
            FSDirectory targetDir = FSDirectory.open(Paths.get(mergeRequest.indexPath, new String[0]));
            IndexWriter writer = new IndexWriter(targetDir, new IndexWriterConfig(null).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
            IIndexManager indexManager = ServiceFactory.getIndexManager();
            Collection<IndexReader> readers = indexManager.getReadersByType(FieldDefinitions.IndexType.Fulltext);
            if (readers != null) {
                ArrayList<Directory> directorList = new ArrayList<Directory>();
                for (IndexReader reader : readers) {
                    DirectoryReader dirReader;
                    Directory dir;
                    if (!(reader instanceof DirectoryReader) || (dir = (dirReader = (DirectoryReader)reader).directory()) == null) continue;
                    directorList.add(dir);
                }
                if (!directorList.isEmpty()) {
                    Directory[] dirArray = directorList.toArray(new Directory[0]);
                    writer.addIndexes(dirArray);
                    writer.forceMerge(1);
                    writer.close();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int openSpellIndexGenerator(String requestAsJson) {
        JSONObject jRequest = new JSONObject(requestAsJson);
        OpenSpellIndexRequest request = OpenSpellIndexRequest.fromJson(jRequest);
        int generatorId = this._indexerId.incrementAndGet();
        SpellIndexer generator = null;
        try {
            generator = new SpellIndexer(request.indexPath, request.openMode);
        }
        catch (Exception e) {
            return -1;
        }
        Map<Integer, SpellIndexer> map = this._activeSpellGenerators;
        synchronized (map) {
            this._activeSpellGenerators.put(generatorId, generator);
        }
        return generatorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeSpellIndexGenerator(int generatorId) throws Exception {
        SpellIndexer generator = null;
        Map<Integer, SpellIndexer> map = this._activeSpellGenerators;
        synchronized (map) {
            generator = this._activeSpellGenerators.get(generatorId);
            this._activeSpellGenerators.remove(generatorId);
        }
        if (generator != null) {
            generator.close();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSpellWords(int generatorId, byte[] data) throws Exception {
        SpellIndexer generator = null;
        Map<Integer, SpellIndexer> map = this._activeSpellGenerators;
        synchronized (map) {
            generator = this._activeSpellGenerators.get(generatorId);
        }
        if (generator != null) {
            SpellDataRequest request = SpellDataRequest.fromBinary(data);
            generator.addWords(request.language, request.words);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int openRelatedIndexGenerator(String requestAsJson) {
        JSONObject jRequest = new JSONObject(requestAsJson);
        OpenRelatedIndexRequest request = OpenRelatedIndexRequest.fromJson(jRequest);
        int generatorId = this._indexerId.incrementAndGet();
        RelatedIndexer generator = null;
        try {
            generator = new RelatedIndexer(request.indexPath, request.openMode);
        }
        catch (Exception e) {
            return -1;
        }
        Map<Integer, RelatedIndexer> map = this._activeRelatedGenerators;
        synchronized (map) {
            this._activeRelatedGenerators.put(generatorId, generator);
        }
        return generatorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeRelatedIndexGenerator(int generatorId) throws Exception {
        RelatedIndexer generator = null;
        Map<Integer, RelatedIndexer> map = this._activeRelatedGenerators;
        synchronized (map) {
            generator = this._activeRelatedGenerators.get(generatorId);
            this._activeRelatedGenerators.remove(generatorId);
        }
        if (generator != null) {
            generator.close();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRelatedWords(int generatorId, byte[] data) throws Exception {
        RelatedIndexer generator = null;
        Map<Integer, RelatedIndexer> map = this._activeRelatedGenerators;
        synchronized (map) {
            generator = this._activeRelatedGenerators.get(generatorId);
        }
        if (generator != null) {
            RelatedDataRequest request = RelatedDataRequest.fromBinary(data);
            generator.addWords(request.language, request.words);
            return true;
        }
        return false;
    }
}

